/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.ft;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.expr.ft.FTExpr;
import org.basex.query.expr.ft.FTFilter;
import org.basex.query.util.ft.FTMatch;
import org.basex.query.util.ft.FTStringMatch;
import org.basex.query.value.node.FElem;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.ft.FTContents;
import org.basex.util.ft.FTLexer;
import org.basex.util.hash.IntObjMap;

public final class FTContent
extends FTFilter {
    private final FTContents content;

    public FTContent(InputInfo info, FTExpr expr, FTContents content) {
        super(info, expr);
        this.content = content;
    }

    @Override
    protected boolean filter(QueryContext qc, FTMatch match, FTLexer lexer) {
        if (this.content == FTContents.START) {
            for (FTStringMatch sm : match) {
                if (sm.start != 0) continue;
                return true;
            }
        } else if (this.content == FTContents.END) {
            int p = lexer.count() - 1;
            for (FTStringMatch sm : match) {
                if (sm.end != p) continue;
                return true;
            }
        } else {
            int s = lexer.count();
            boolean[] bl = new boolean[s];
            for (FTStringMatch sm : match) {
                if (sm.gaps) continue;
                for (int p = sm.start; p <= sm.end; ++p) {
                    bl[p] = true;
                }
            }
            for (Object b : (Object)bl) {
                if (b != false) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean content() {
        return this.content != FTContents.START;
    }

    @Override
    public FTExpr copy(CompileContext cc, IntObjMap<Var> vm) {
        return new FTContent(this.info, (FTExpr)this.exprs[0].copy(cc, (IntObjMap)vm), this.content);
    }

    @Override
    public void plan(FElem plan) {
        FTContent.addPlan(plan, this.planElem("content", this.content.toString()), this.exprs);
    }

    @Override
    public String toString() {
        return super.toString() + (this.content == FTContents.START ? "at start" : (this.content == FTContents.END ? "at end" : "entire content"));
    }
}

