/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.constr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.Map;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public final class CMap
extends Arr {
    public CMap(InputInfo info, Expr[] expr) {
        super(info, SeqType.MAP_O, expr);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        int el = this.exprs.length;
        AtomType key = null;
        for (int e = 0; e < el; e += 2) {
            SeqType st = this.exprs[e].seqType();
            AtomType type = st.type.atomic();
            if (type == null || !st.one()) {
                key = null;
                break;
            }
            key = key == null ? type : key.union(type);
        }
        SeqType vt = null;
        for (int e = 1; e < el; e += 2) {
            SeqType dst = this.exprs[e].seqType();
            vt = vt == null ? dst : vt.union(dst);
        }
        if (key != null) {
            this.exprType.assign(MapType.get(key, vt));
        }
        return this.allAreValues(true) ? cc.preEval(this) : this;
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Map map = Map.EMPTY;
        int el = this.exprs.length;
        for (int e = 0; e < el; e += 2) {
            Value key = this.exprs[e].atomValue(qc, this.info);
            if (!(key instanceof Item)) {
                throw QueryError.SEQFOUND_X.get(this.info, key);
            }
            Item k = (Item)key;
            Value v = this.exprs[e + 1].value(qc);
            if (map.contains(k, this.info)) {
                throw QueryError.MAPDUPLKEY_X_X_X.get(this.info, k, map.get(k, this.info), v);
            }
            map = map.put(k, v, this.info);
        }
        return map;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new CMap(this.info, CMap.copyAll((CompileContext)cc, vm, (Expr[])this.exprs)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof CMap && super.equals(obj);
    }

    @Override
    public String description() {
        return "map";
    }

    @Override
    public String toString() {
        TokenBuilder tb = new TokenBuilder("map { ");
        int el = this.exprs.length;
        for (int e = 0; e < el; e += 2) {
            if (e != 0) {
                tb.add(", ");
            }
            tb.addExt(this.exprs[e], new Object[0]).add(": ").addExt(this.exprs[e + 1], new Object[0]);
        }
        return tb.add(" }").toString();
    }
}

