/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Arr;
import org.basex.query.expr.Catch;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Try
extends Single {
    private final Catch[] catches;

    public Try(InputInfo info, Expr expr, Catch[] catches) {
        super(info, expr, SeqType.ITEM_ZM);
        this.catches = catches;
    }

    @Override
    public void checkUp() throws QueryException {
        int cl = this.catches.length;
        Expr[] tmp = new Expr[cl + 1];
        tmp[0] = this.expr;
        for (int c = 0; c < cl; ++c) {
            tmp[c + 1] = this.catches[c].expr;
        }
        this.checkAllUp(tmp);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        try {
            super.compile(cc);
        }
        catch (QueryException ex) {
            if (!ex.isCatchable()) {
                throw ex;
            }
            for (Catch ctch : this.catches) {
                if (!ctch.matches(ex)) continue;
                return cc.replaceWith(this, ctch.compile(cc).asExpr(ex, cc));
            }
            throw ex;
        }
        for (Catch ctch : this.catches) {
            ctch.compile(cc);
        }
        return this.optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) {
        if (this.expr instanceof Value) {
            return cc.replaceWith(this, this.expr);
        }
        SeqType st = this.expr.seqType();
        for (Catch ctch : this.catches) {
            if (ctch.expr.isFunction(Function.ERROR)) continue;
            st = st.union(ctch.seqType());
        }
        this.exprType.assign(st);
        return this;
    }

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        try {
            return this.expr.value(qc);
        }
        catch (QueryException ex) {
            if (ex.isCatchable()) {
                for (Catch ctch : this.catches) {
                    if (!ctch.matches(ex)) continue;
                    return ctch.value(qc, ex);
                }
            }
            throw ex;
        }
    }

    @Override
    public VarUsage count(Var var) {
        return VarUsage.maximum(var, this.catches).plus(this.expr.count(var));
    }

    @Override
    public Expr inline(Var var, Expr ex, CompileContext cc) throws QueryException {
        boolean changed = false;
        try {
            Expr sub = this.expr.inline(var, ex, cc);
            if (sub != null) {
                if (sub instanceof Value) {
                    return cc.replaceWith(this, sub);
                }
                this.expr = sub;
                changed = true;
            }
        }
        catch (QueryException qe) {
            if (!qe.isCatchable()) {
                throw qe;
            }
            for (Catch ctch : this.catches) {
                if (!ctch.matches(qe)) continue;
                Catch nw = ctch.inline(var, ex, cc);
                return cc.replaceWith(this, (nw == null ? ctch : nw).asExpr(qe, cc));
            }
            throw qe;
        }
        for (Catch ctch : this.catches) {
            changed |= ctch.inline(var, ex, cc) != null;
        }
        return changed ? this : null;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Try(this.info, this.expr.copy(cc, vm), (Catch[])Arr.copyAll((CompileContext)cc, vm, (Expr[])this.catches)));
    }

    @Override
    public boolean has(Flag ... flags) {
        for (Catch ctch : this.catches) {
            if (!ctch.has(flags)) continue;
            return true;
        }
        return super.has(flags);
    }

    @Override
    public boolean removable(Var var) {
        for (Catch ctch : this.catches) {
            if (ctch.removable(var)) continue;
            return false;
        }
        return super.removable(var);
    }

    @Override
    public void markTailCalls(CompileContext cc) {
        for (Catch ctch : this.catches) {
            ctch.markTailCalls(cc);
        }
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return super.accept(visitor) && Try.visitAll(visitor, this.catches);
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (Catch ctch : this.catches) {
            size += ctch.exprSize();
        }
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Try && Array.equals(this.catches, ((Try)obj).catches) && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        Try.addPlan(plan, this.planElem(new Object[0]), new Object[]{this.expr, this.catches});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("try { " + this.expr + " }");
        for (Catch ctch : this.catches) {
            sb.append(' ').append(ctch);
        }
        return sb.toString();
    }
}

