/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.BitSet;
import org.basex.data.Data;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.TypeCheck;
import org.basex.query.func.Function;
import org.basex.query.iter.AtomIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.IndexInfo;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public abstract class Expr
extends ExprInfo {
    public abstract boolean equals(Object var1);

    public abstract void checkUp() throws QueryException;

    public abstract Expr compile(CompileContext var1) throws QueryException;

    public Expr optimize(CompileContext cc) throws QueryException {
        return this;
    }

    public abstract Iter iter(QueryContext var1) throws QueryException;

    public abstract Item item(QueryContext var1, InputInfo var2) throws QueryException;

    public abstract Value value(QueryContext var1) throws QueryException;

    public final Iter atomIter(QueryContext qc, InputInfo ii) throws QueryException {
        Iter iter = this.iter(qc);
        SeqType st = this.seqType();
        return st.type.instanceOf(AtomType.AAT) ? iter : new AtomIter(iter, qc, ii, st.mayBeArray() ? -1L : iter.size());
    }

    public abstract Item atomItem(QueryContext var1, InputInfo var2) throws QueryException;

    public abstract Value atomValue(QueryContext var1, InputInfo var2) throws QueryException;

    public abstract Item ebv(QueryContext var1, InputInfo var2) throws QueryException;

    public abstract Item test(QueryContext var1, InputInfo var2) throws QueryException;

    public boolean isVacuous() {
        return false;
    }

    public Data data() {
        return null;
    }

    public abstract long size();

    public abstract boolean has(Flag ... var1);

    public final boolean uses(final Var var) {
        return !this.accept(new ASTVisitor(){

            @Override
            public boolean used(VarRef ref) {
                return !ref.var.is(var);
            }
        });
    }

    public abstract boolean removable(Var var1);

    public abstract VarUsage count(Var var1);

    public abstract Expr inline(Var var1, Expr var2, CompileContext var3) throws QueryException;

    protected static boolean inlineAll(Expr[] array, Var var, Expr expr, CompileContext cc) throws QueryException {
        boolean changed = false;
        int al = array.length;
        for (int a = 0; a < al; ++a) {
            Expr ex = array[a].inline(var, expr, cc);
            if (ex == null) continue;
            array[a] = ex;
            changed = true;
        }
        return changed;
    }

    public abstract Expr copy(CompileContext var1, IntObjMap<Var> var2);

    public Expr optimizeEbv(CompileContext cc) throws QueryException {
        SeqType st = this.seqType();
        return st.type instanceof NodeType && st.oneOrMore() && !this.has(Flag.NDT) ? cc.replaceEbv(this, Bln.TRUE) : this;
    }

    public abstract SeqType seqType();

    public boolean iterable() {
        return this.seqType().zeroOrOne();
    }

    public boolean indexAccessible(IndexInfo ii) throws QueryException {
        return false;
    }

    public boolean isFunction(Function func) {
        return false;
    }

    public final boolean isSimple() {
        return !this.has(Flag.CTX, Flag.NDT, Flag.HOF, Flag.POS);
    }

    protected boolean hasFreeVars() {
        final BitSet declared = new BitSet();
        return !this.accept(new ASTVisitor(){

            @Override
            public boolean declared(Var var) {
                declared.set(var.id);
                return true;
            }

            @Override
            public boolean used(VarRef ref) {
                return declared.get(ref.var.id);
            }
        });
    }

    public void markTailCalls(CompileContext cc) {
    }

    public abstract boolean accept(ASTVisitor var1);

    protected static boolean visitAll(ASTVisitor visitor, Expr ... exprs) {
        for (Expr expr : exprs) {
            if (expr.accept(visitor)) continue;
            return false;
        }
        return true;
    }

    public abstract int exprSize();

    protected Expr typeCheck(TypeCheck tc, CompileContext cc) throws QueryException {
        return null;
    }
}

