/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.Expr;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class CmpV
extends Cmp {
    OpV op;

    public CmpV(Expr expr1, Expr expr2, OpV op, Collation coll, StaticContext sc, InputInfo info) {
        super(info, expr1, expr2, coll, SeqType.BLN_ZO, sc);
        this.op = op;
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        Expr expr;
        if (this.oneIsEmpty()) {
            return cc.emptySeq(this);
        }
        if (this.exprs[1].seqType().oneNoArray() && this.exprs[0].seqType().oneNoArray()) {
            this.exprType.assign(Occ.ONE);
        }
        if (this.swap()) {
            cc.info("swap operands: %", this);
            this.op = this.op.swap();
        }
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        SeqType st1 = expr1.seqType();
        SeqType st2 = expr2.seqType();
        Type type1 = st1.type;
        Type type2 = st2.type;
        this.check = !(type1 == type2 && !AtomType.AAT.instanceOf(type1) && (type1.isSortable() || this.op != OpV.EQ && this.op != OpV.NE) || type1.isStringOrUntyped() && type2.isStringOrUntyped() || type1.instanceOf(AtomType.NUM) && type2.instanceOf(AtomType.NUM) || type1.instanceOf(AtomType.DUR) && type2.instanceOf(AtomType.DUR));
        Expr expr3 = expr = this.check || !st1.oneNoArray() || !st2.oneNoArray() ? this : new CmpG(expr1, expr2, CmpG.OpG.get(this.op), this.coll, this.sc, this.info).optimize(cc);
        if (expr == this) {
            expr = this.opt(this.op, cc);
        }
        return this.allAreValues(false) ? cc.preEval(expr) : cc.replaceWith(this, expr);
    }

    @Override
    public Expr optimizeEbv(CompileContext cc) {
        return (this.op == OpV.EQ && this.exprs[1] == Bln.TRUE || this.op == OpV.NE && this.exprs[1] == Bln.FALSE) && this.exprs[0].seqType().eq(SeqType.BLN_O) ? cc.replaceEbv(this, this.exprs[0]) : this;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item1 = this.exprs[0].atomItem(qc, this.info);
        if (item1 == null) {
            return null;
        }
        Item item2 = this.exprs[1].atomItem(qc, this.info);
        if (item2 == null) {
            return null;
        }
        if (item1.comparable(item2)) {
            return Bln.get(this.op.eval(item1, item2, this.coll, this.sc, this.info));
        }
        throw QueryError.diffError(item1, item2, this.info);
    }

    @Override
    public Expr invert(CompileContext cc) throws QueryException {
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        SeqType st1 = expr1.seqType();
        SeqType st2 = expr2.seqType();
        return st1.oneNoArray() && st2.oneNoArray() ? new CmpV(expr1, expr2, this.op.invert(), this.coll, this.sc, this.info).optimize(cc) : this;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        CmpV cmp = new CmpV(this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm), this.op, this.coll, this.sc, this.info);
        cmp.check = this.check;
        return this.copyType(cmp);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof CmpV && this.op == ((CmpV)obj).op && super.equals(obj);
    }

    @Override
    public void plan(FElem plan) {
        CmpV.addPlan(plan, this.planElem("op", this.op.name), this.exprs);
    }

    @Override
    public String description() {
        return "'" + (Object)((Object)this.op) + "' operator";
    }

    @Override
    public String toString() {
        return this.toString(" " + (Object)((Object)this.op) + ' ');
    }

    public static enum OpV {
        LE("le"){

            @Override
            public boolean eval(Item item1, Item item2, Collation coll, StaticContext sc, InputInfo info) throws QueryException {
                int v = item1.diff(item2, coll, info);
                return v != Integer.MIN_VALUE && v <= 0;
            }

            @Override
            public OpV swap() {
                return GE;
            }

            @Override
            public OpV invert() {
                return GT;
            }
        }
        ,
        LT("lt"){

            @Override
            public boolean eval(Item item1, Item item2, Collation coll, StaticContext sc, InputInfo info) throws QueryException {
                int v = item1.diff(item2, coll, info);
                return v != Integer.MIN_VALUE && v < 0;
            }

            @Override
            public OpV swap() {
                return GT;
            }

            @Override
            public OpV invert() {
                return GE;
            }
        }
        ,
        GE("ge"){

            @Override
            public boolean eval(Item item1, Item item2, Collation coll, StaticContext sc, InputInfo info) throws QueryException {
                int v = item1.diff(item2, coll, info);
                return v != Integer.MIN_VALUE && v >= 0;
            }

            @Override
            public OpV swap() {
                return LE;
            }

            @Override
            public OpV invert() {
                return LT;
            }
        }
        ,
        GT("gt"){

            @Override
            public boolean eval(Item item1, Item item2, Collation coll, StaticContext sc, InputInfo info) throws QueryException {
                int v = item1.diff(item2, coll, info);
                return v != Integer.MIN_VALUE && v > 0;
            }

            @Override
            public OpV swap() {
                return LT;
            }

            @Override
            public OpV invert() {
                return LE;
            }
        }
        ,
        EQ("eq"){

            @Override
            public boolean eval(Item item1, Item item2, Collation coll, StaticContext sc, InputInfo info) throws QueryException {
                return item1.eq(item2, coll, sc, info);
            }

            @Override
            public OpV swap() {
                return EQ;
            }

            @Override
            public OpV invert() {
                return NE;
            }
        }
        ,
        NE("ne"){

            @Override
            public boolean eval(Item item1, Item item2, Collation coll, StaticContext sc, InputInfo info) throws QueryException {
                return !item1.eq(item2, coll, sc, info);
            }

            @Override
            public OpV swap() {
                return NE;
            }

            @Override
            public OpV invert() {
                return EQ;
            }
        };

        public static final OpV[] VALUES;
        public final String name;

        private OpV(String name) {
            this.name = name;
        }

        public abstract boolean eval(Item var1, Item var2, Collation var3, StaticContext var4, InputInfo var5) throws QueryException;

        public abstract OpV swap();

        public abstract OpV invert();

        public String toString() {
            return this.name;
        }

        static {
            VALUES = OpV.values();
        }
    }
}

