/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.index.IndexType;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpHashG;
import org.basex.query.expr.CmpR;
import org.basex.query.expr.CmpSR;
import org.basex.query.expr.CmpSimpleG;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.func.fn.FnTokenize;
import org.basex.query.iter.Iter;
import org.basex.query.util.IndexInfo;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public class CmpG
extends Cmp {
    OpG op;

    public CmpG(Expr expr1, Expr expr2, OpG op, Collation coll, StaticContext sc, InputInfo info) {
        super(info, expr1, expr2, coll, SeqType.BLN_O, sc);
        this.op = op;
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        if (this.oneIsEmpty()) {
            return cc.replaceWith(this, Bln.FALSE);
        }
        if (this.swap()) {
            cc.info("swap operands: %", this);
            this.op = this.op.swap();
        }
        Expr expr = this.opt(this.op.op, cc);
        for (int e = 0; e < 2; ++e) {
            if (!(this.exprs[e] instanceof SingletonSeq)) continue;
            this.exprs[e] = ((SingletonSeq)this.exprs[e]).value;
        }
        if (expr == this) {
            expr = CmpR.get(this, cc);
        }
        if (expr == this) {
            expr = CmpSR.get(this, cc);
        }
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        SeqType st1 = expr1.seqType();
        SeqType st2 = expr2.seqType();
        Type type1 = st1.type;
        Type type2 = st2.type;
        boolean bl = this.check = !(type1 == type2 && !AtomType.AAT.instanceOf(type1) && (type1.isSortable() || this.op != OpG.EQ && this.op != OpG.NE) || type1.isUntyped() || type2.isUntyped() || type1.instanceOf(AtomType.STR) && type2.instanceOf(AtomType.STR) || type1.instanceOf(AtomType.NUM) && type2.instanceOf(AtomType.NUM) || type1.instanceOf(AtomType.DUR) && type2.instanceOf(AtomType.DUR));
        if (expr == this && st1.zeroOrOne() && !st1.mayBeArray() && st2.zeroOrOne() && !st2.mayBeArray()) {
            expr = new CmpSimpleG(expr1, expr2, this.op, this.coll, this.sc, this.info);
        }
        if (expr == this && this.op == OpG.EQ && this.coll == null && (type1.isNumber() && type2.isNumber() || type1.isStringOrUntyped() && type2.isStringOrUntyped()) && !st2.zeroOrOne()) {
            expr = new CmpHashG(expr1, expr2, this.op, this.coll, this.sc, this.info);
        }
        return this.allAreValues(false) ? cc.preEval(expr) : cc.replaceWith(this, expr);
    }

    @Override
    public Expr optimizeEbv(CompileContext cc) {
        return (this.op == OpG.EQ && this.exprs[1] == Bln.TRUE || this.op == OpG.NE && this.exprs[1] == Bln.FALSE) && this.exprs[0].seqType().eq(SeqType.BLN_O) ? cc.replaceEbv(this, this.exprs[0]) : this;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        Iter iter1 = this.exprs[0].atomIter(qc, this.info);
        long size1 = iter1.size();
        if (size1 == 0L) {
            return Bln.FALSE;
        }
        Iter iter2 = this.exprs[1].atomIter(qc, this.info);
        long size2 = iter2.size();
        return size2 == 0L ? Bln.FALSE : this.compare(iter1, iter2, size1, size2, qc);
    }

    Bln compare(Iter iter1, Iter iter2, long size1, long size2, QueryContext qc) throws QueryException {
        Item item1;
        boolean swap;
        boolean single2;
        Iter ir1 = iter1;
        Iter ir2 = iter2;
        boolean single1 = size1 == 1L;
        boolean bl = single2 = size2 == 1L;
        if (single1 && single2) {
            return Bln.get(this.eval(ir1.next(), ir2.next()));
        }
        if (single1) {
            Item item2;
            Item item12 = ir1.next();
            while ((item2 = qc.next(ir2)) != null) {
                if (!this.eval(item12, item2)) continue;
                return Bln.TRUE;
            }
            return Bln.FALSE;
        }
        if (single2) {
            Item item13;
            Item item2 = ir2.next();
            while ((item13 = qc.next(ir1)) != null) {
                if (!this.eval(item13, item2)) continue;
                return Bln.TRUE;
            }
            return Bln.FALSE;
        }
        boolean bl2 = swap = size1 > size2;
        if (swap) {
            Iter iter = ir1;
            ir1 = ir2;
            ir2 = iter;
        }
        while ((item1 = ir1.next()) != null) {
            Item item2;
            if (ir2 == null) {
                ir2 = this.exprs[swap ? 0 : 1].atomIter(qc, this.info);
            }
            while ((item2 = qc.next(ir2)) != null) {
                if (!(swap ? this.eval(item2, item1) : this.eval(item1, item2))) continue;
                return Bln.TRUE;
            }
            ir2 = null;
        }
        return Bln.FALSE;
    }

    final boolean eval(Item item1, Item item2) throws QueryException {
        Type type2;
        Type type1;
        if (!(!this.check || (type1 = item1.type) == (type2 = item2.type) || type1.isUntyped() || type2.isUntyped() || item1 instanceof ANum && item2 instanceof ANum || item1 instanceof AStr && item2 instanceof AStr || item1 instanceof Dur && item2 instanceof Dur)) {
            throw QueryError.diffError(item1, item2, this.info);
        }
        return this.op.op.eval(item1, item2, this.coll, this.sc, this.info);
    }

    @Override
    public final Expr invert(CompileContext cc) throws QueryException {
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        SeqType st1 = expr1.seqType();
        SeqType st2 = expr2.seqType();
        return st1.oneNoArray() && st2.oneNoArray() ? new CmpG(expr1, expr2, this.op.invert(), this.coll, this.sc, this.info).optimize(cc) : this;
    }

    final Expr union(CmpG g, CompileContext cc) throws QueryException {
        if (this.op != g.op || this.coll != g.coll || !this.exprs[0].equals(g.exprs[0])) {
            return null;
        }
        Expr list = new List(this.info, this.exprs[1], g.exprs[1]).optimize(cc);
        return new CmpG(this.exprs[0], list, this.op, this.coll, this.sc, this.info).optimize(cc);
    }

    @Override
    public final boolean indexAccessible(IndexInfo ii) throws QueryException {
        if (this.op != OpG.EQ || this.coll != null) {
            return false;
        }
        Expr expr1 = this.exprs[0];
        boolean tokenize = expr1 instanceof FnTokenize;
        if (tokenize) {
            expr1 = ((FnTokenize)expr1).input();
        }
        return ii.create(this.exprs[1], ii.type(expr1, tokenize ? IndexType.TOKEN : null), this.info, false);
    }

    @Override
    public CmpG copy(CompileContext cc, IntObjMap<Var> vm) {
        CmpG cmp = new CmpG(this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm), this.op, this.coll, this.sc, this.info);
        cmp.check = this.check;
        return cmp;
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof CmpG && this.op == ((CmpG)obj).op && super.equals(obj);
    }

    @Override
    public final void plan(FElem plan) {
        CmpG.addPlan(plan, this.planElem("op", this.op.name), this.exprs);
    }

    @Override
    public String description() {
        return (Object)((Object)this.op) + " operator";
    }

    @Override
    public final String toString() {
        return this.toString(" " + (Object)((Object)this.op) + ' ');
    }

    public static enum OpG {
        LE("<=", CmpV.OpV.LE){

            @Override
            public OpG swap() {
                return GE;
            }

            @Override
            public OpG invert() {
                return GT;
            }
        }
        ,
        LT("<", CmpV.OpV.LT){

            @Override
            public OpG swap() {
                return GT;
            }

            @Override
            public OpG invert() {
                return GE;
            }
        }
        ,
        GE(">=", CmpV.OpV.GE){

            @Override
            public OpG swap() {
                return LE;
            }

            @Override
            public OpG invert() {
                return LT;
            }
        }
        ,
        GT(">", CmpV.OpV.GT){

            @Override
            public OpG swap() {
                return LT;
            }

            @Override
            public OpG invert() {
                return LE;
            }
        }
        ,
        EQ("=", CmpV.OpV.EQ){

            @Override
            public OpG swap() {
                return EQ;
            }

            @Override
            public OpG invert() {
                return NE;
            }
        }
        ,
        NE("!=", CmpV.OpV.NE){

            @Override
            public OpG swap() {
                return NE;
            }

            @Override
            public OpG invert() {
                return EQ;
            }
        };

        public static final OpG[] VALUES;
        public final String name;
        public final CmpV.OpV op;

        private OpG(String name, CmpV.OpV op) {
            this.name = name;
            this.op = op;
        }

        public abstract OpG swap();

        public abstract OpG invert();

        public String toString() {
            return this.name;
        }

        static OpG get(CmpV.OpV cmp) {
            for (OpG value : VALUES) {
                if (value.op != cmp) continue;
                return value;
            }
            return null;
        }

        static {
            VALUES = OpG.values();
        }
    }
}

