/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.value;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.index.IndexCache;
import org.basex.index.IndexEntry;
import org.basex.index.IndexType;
import org.basex.index.query.EntryIterator;
import org.basex.index.query.IndexEntries;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.IndexToken;
import org.basex.index.query.NumericRange;
import org.basex.index.query.StringRange;
import org.basex.index.stats.IndexStats;
import org.basex.index.value.ValueCache;
import org.basex.index.value.ValueIndex;
import org.basex.io.random.DataAccess;
import org.basex.query.util.IndexCosts;
import org.basex.util.Num;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;
import org.basex.util.list.IntList;

public class DiskValues
extends ValueIndex {
    final DataAccess idxr;
    final DataAccess idxl;
    final IndexCache cache = new IndexCache();
    final IntObjMap<byte[]> ctext = new IntObjMap();
    final AtomicInteger size = new AtomicInteger();
    private final Object monitor = new Object();

    public DiskValues(Data data, IndexType type) throws IOException {
        this(data, type, DiskValues.fileSuffix(type));
    }

    DiskValues(Data data, IndexType type, String pref) throws IOException {
        super(data, type);
        this.idxl = new DataAccess(data.meta.dbfile(pref + 'l'));
        this.idxr = new DataAccess(data.meta.dbfile(pref + 'r'));
        this.size.set(this.idxl.read4());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final byte[] info(MainOptions options) {
        TokenBuilder tb = new TokenBuilder();
        tb.add("- Structure: ").add("Sorted List").add(Text.NL);
        tb.add("- Names: ").add(this.data.meta.names(this.type)).add(Text.NL);
        IndexStats stats = new IndexStats(options.get(MainOptions.MAXSTAT));
        Object object = this.monitor;
        synchronized (object) {
            long l = this.idxl.length() + this.idxr.length();
            tb.add("- Size: ").add(Performance.format(l)).add(Text.NL);
            int entries = this.size();
            for (int index = 0; index < entries; ++index) {
                long pos = this.idxr.read5((long)index * 5L);
                int count = this.idxl.readNum(pos);
                if (!stats.adding(count)) continue;
                stats.add(this.key(this.idxl.readNum()), count);
            }
        }
        stats.print(tb);
        return tb.finish();
    }

    @Override
    public final int size() {
        return this.size.get();
    }

    @Override
    public final IndexCosts costs(IndexToken it) {
        return IndexCosts.get(it instanceof StringRange ? Math.max(1, this.data.meta.size / 10) : (it instanceof NumericRange ? Math.max(1, this.data.meta.size / 3) : this.entry((byte[])it.get()).size));
    }

    @Override
    public final IndexIterator iter(IndexToken it) {
        if (it instanceof StringRange) {
            return this.idRange((StringRange)it);
        }
        if (it instanceof NumericRange) {
            return this.idRange((NumericRange)it);
        }
        IndexEntry ie = this.entry(it.get());
        return this.iter(ie.size, ie.offset);
    }

    @Override
    public final boolean drop() {
        return this.data.meta.drop(DiskValues.fileSuffix(this.type) + '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        Object object = this.monitor;
        synchronized (object) {
            this.idxl.close();
            this.idxr.close();
        }
    }

    @Override
    public void add(ValueCache vc) {
        throw Util.notExpected();
    }

    @Override
    public void delete(ValueCache vc) {
        throw Util.notExpected();
    }

    @Override
    public final EntryIterator entries(IndexEntries input) {
        byte[] key = input.get();
        if (key.length == 0) {
            return this.allKeys(input.descending);
        }
        if (input.prefix) {
            return this.keysWithPrefix(key);
        }
        return this.keysFrom(key, input.descending);
    }

    @Override
    public final void flush() {
        this.idxl.flush();
        this.idxr.flush();
    }

    protected int pre(int id) {
        return id;
    }

    protected final int get(byte[] key) {
        return this.get(key, 0, this.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int get(byte[] key, int first, int last) {
        int l = first;
        int h = last - 1;
        Object object = this.monitor;
        synchronized (object) {
            while (l <= h) {
                int m = l + h >>> 1;
                byte[] txt = this.indexEntry((int)m).key;
                int d = Token.diff(txt, key);
                if (d == 0) {
                    return m;
                }
                if (d < 0) {
                    l = m + 1;
                    continue;
                }
                h = m - 1;
            }
        }
        return -(l + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexEntry entry(byte[] key) {
        long offset;
        int count;
        IndexEntry entry = this.cache.get(key);
        if (entry != null) {
            return entry;
        }
        long index = this.get(key);
        if (index < 0L) {
            return new IndexEntry(key, 0, 0L);
        }
        Object object = this.monitor;
        synchronized (object) {
            long pos = this.idxr.read5(index * 5L);
            count = this.idxl.readNum(pos);
            offset = this.idxl.cursor();
        }
        return this.cache.add(key, count, offset);
    }

    private EntryIterator allKeys(boolean reverse) {
        int s = this.size() - 1;
        return reverse ? this.keysWithinReverse(0, s) : this.keysWithin(0, s);
    }

    private EntryIterator keysFrom(byte[] key, boolean reverse) {
        int s = this.size() - 1;
        int i = this.get(key);
        if (i < 0) {
            i = -i - 1;
        }
        return reverse ? this.keysWithinReverse(0, i - 1) : this.keysWithin(i, s);
    }

    private EntryIterator keysWithPrefix(final byte[] prefix) {
        final int i = this.get(prefix);
        return new EntryIterator(){
            final int s;
            int ix;
            int count;
            {
                this.s = DiskValues.this.size();
                this.ix = (i < 0 ? -i - 1 : i) - 1;
                this.count = -1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] next() {
                if (++this.ix < this.s) {
                    Object object = DiskValues.this.monitor;
                    synchronized (object) {
                        IndexEntry entry = DiskValues.this.indexEntry(this.ix);
                        if (Token.startsWith(entry.key, prefix)) {
                            this.count = entry.size;
                            return entry.key;
                        }
                    }
                }
                this.count = -1;
                return null;
            }

            @Override
            public int count() {
                return this.count;
            }
        };
    }

    private EntryIterator keysWithin(final int first, final int last) {
        return new EntryIterator(){
            int ix;
            int count;
            {
                this.ix = first - 1;
                this.count = -1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] next() {
                if (++this.ix <= last) {
                    Object object = DiskValues.this.monitor;
                    synchronized (object) {
                        IndexEntry entry = DiskValues.this.indexEntry(this.ix);
                        this.count = entry.size;
                        return entry.key;
                    }
                }
                this.count = -1;
                return null;
            }

            @Override
            public int count() {
                return this.count;
            }
        };
    }

    private EntryIterator keysWithinReverse(final int first, final int last) {
        return new EntryIterator(){
            int ix;
            int count;
            {
                this.ix = last + 1;
                this.count = -1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] next() {
                if (--this.ix >= first) {
                    Object object = DiskValues.this.monitor;
                    synchronized (object) {
                        IndexEntry entry = DiskValues.this.indexEntry(this.ix);
                        this.count = entry.size;
                        return entry.key;
                    }
                }
                this.count = -1;
                return null;
            }

            @Override
            public int count() {
                return this.count;
            }
        };
    }

    private IndexEntry indexEntry(int index) {
        IndexEntry entry;
        byte[] key = this.ctext.get(index);
        if (key != null && (entry = this.cache.get(key)) != null) {
            return entry;
        }
        long pos = this.idxr.read5((long)index * 5L);
        int count = this.idxl.readNum(pos);
        if (key == null) {
            key = this.key(this.idxl.readNum());
            this.ctext.put(index, key);
        }
        return this.cache.add(key, count, pos + (long)Num.length(count));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexIterator iter(int sz, long offset) {
        IntList pres = new IntList(sz);
        Object object = this.monitor;
        synchronized (object) {
            this.idxl.cursor(offset);
            int id = 0;
            for (int i = 0; i < sz; ++i) {
                id += this.idxl.readNum();
                if (this.type == IndexType.TOKEN) {
                    this.idxl.readNum();
                }
                pres.add(this.pre(id));
            }
        }
        return DiskValues.iter(pres.sort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexIterator idRange(StringRange tok) {
        IntList pres = new IntList();
        Object object = this.monitor;
        synchronized (object) {
            int index;
            int i = this.get(tok.min);
            int entries = this.size();
            int n = i < 0 ? -i - 1 : (index = tok.mni ? i : i + 1);
            while (index < entries) {
                int count = this.idxl.readNum(this.idxr.read5((long)index * 5L));
                int id = this.idxl.readNum();
                int diff = Token.diff(this.key(id), tok.max);
                if (diff > 0 || !tok.mxi && diff == 0) break;
                for (int c = 0; c < count; ++c) {
                    pres.add(this.pre(id));
                    id += this.idxl.readNum();
                }
                ++index;
            }
        }
        return DiskValues.iter(pres.sort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexIterator idRange(NumericRange tok) {
        double min = tok.min;
        double max = tok.max;
        int len = max > 0.0 && (double)((long)max) == max ? Token.token(max).length : 0;
        boolean simple = len != 0 && min > 0.0 && (double)((long)min) == min && Token.token(min).length == len;
        IntList pres = new IntList();
        Object object = this.monitor;
        synchronized (object) {
            int entries = this.size();
            boolean text = this.type == IndexType.TEXT;
            for (int index = 0; index < entries; ++index) {
                int count = this.idxl.readNum(this.idxr.read5((long)index * 5L));
                int id = this.idxl.readNum();
                int pre = this.pre(id);
                double v = this.data.textDbl(pre, text);
                if (v >= min && v <= max) {
                    for (int c = 0; c < count; ++c) {
                        pres.add(this.pre(id));
                        id += this.idxl.readNum();
                    }
                    continue;
                }
                if (simple && v > max && this.data.textLen(pre, text) == len) break;
            }
        }
        return DiskValues.iter(pres.sort());
    }

    private static IndexIterator iter(final IntList pres) {
        return new IndexIterator(){
            final int s;
            int p;
            {
                this.s = pres.size();
                this.p = -1;
            }

            @Override
            public boolean more() {
                return ++this.p < this.s;
            }

            @Override
            public int pre() {
                return pres.get(this.p);
            }

            @Override
            public int size() {
                return this.s;
            }
        };
    }

    private byte[] key(int id) {
        byte[] text = this.data.text(this.pre(id), this.type == IndexType.TEXT);
        return this.type == IndexType.TOKEN ? Token.distinctTokens(text)[this.idxl.readNum()] : text;
    }

    public final String toString(boolean all) {
        TokenBuilder tb = new TokenBuilder();
        tb.addExt((Object)this.type, new Object[0]).add(" INDEX, '").add(this.data.meta.name).add("':\n");
        int entries = this.size();
        for (int index = 0; index < entries; ++index) {
            long pos = this.idxr.read5((long)index * 5L);
            int count = this.idxl.readNum(pos);
            int id = this.idxl.readNum();
            tb.add("  ").addInt(index).add(". offset: ").addLong(pos);
            if (all) {
                tb.add(", key: \"").add(this.key(id)).add(34);
                tb.add(", ids").add("/pres").add(": ").addInt(id).add(47).addInt(this.pre(id));
            } else {
                tb.add(", ids").add(": ").addInt(id);
            }
            for (int c = 1; c < count; ++c) {
                tb.add(",").addInt(id += this.idxl.readNum());
                if (!all) continue;
                tb.add(47).addInt(this.pre(id));
            }
            tb.add("\n");
        }
        return tb.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    static String fileSuffix(IndexType type) {
        return type == IndexType.TOKEN ? "tok" : (type == IndexType.TEXT ? "txt" : "atv");
    }
}

