/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.ft;

import java.io.IOException;
import org.basex.core.BaseXException;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.index.IndexBuilder;
import org.basex.index.IndexType;
import org.basex.index.ft.FTIndex;
import org.basex.index.ft.FTIndexTree;
import org.basex.index.ft.FTIndexTrees;
import org.basex.index.ft.FTList;
import org.basex.io.out.DataOutput;
import org.basex.util.Num;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.ft.FTCase;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.ft.Stemmer;
import org.basex.util.ft.StopWords;
import org.basex.util.ft.Tokenizer;
import org.basex.util.list.IntList;

public final class FTBuilder
extends IndexBuilder {
    private final FTIndexTrees tree;
    private final FTLexer lexer;
    private long ntok;

    public FTBuilder(Data data) throws IOException {
        super(data, IndexType.FULLTEXT);
        MetaData meta = data.meta;
        this.tree = new FTIndexTrees(data.meta.maxlen);
        FTOpt fto = new FTOpt();
        fto.set(FTFlag.DC, meta.diacritics);
        fto.set(FTFlag.ST, meta.stemming);
        fto.cs = meta.casesens ? FTCase.SENSITIVE : FTCase.INSENSITIVE;
        fto.sw = new StopWords(data, meta.stopwords);
        fto.ln = data.meta.language;
        if (!Tokenizer.supportFor(fto.ln)) {
            throw new BaseXException(Text.NO_TOKENIZER_X, fto.ln);
        }
        if (meta.stemming && !Stemmer.supportFor(fto.ln)) {
            throw new BaseXException(Text.NO_STEMMER_X, fto.ln);
        }
        this.lexer = new FTLexer(fto);
    }

    @Override
    public FTIndex build() throws IOException {
        Util.debug(this.detailedInfo(), new Object[0]);
        try {
            this.pre = 0;
            while (this.pre < this.size) {
                if ((this.pre & 0xFFF) == 0) {
                    this.check();
                }
                if (this.indexEntry()) {
                    StopWords sw = this.lexer.ftOpt().sw;
                    this.lexer.init(this.data.text(this.pre, true));
                    int pos = -1;
                    while (this.lexer.hasNext()) {
                        byte[] tok = this.lexer.nextToken();
                        ++pos;
                        if (tok.length > this.data.meta.maxlen || !sw.isEmpty() && sw.contains(tok)) continue;
                        if ((this.ntok++ & 0xFFFFL) == 0L && this.splitRequired()) {
                            this.writeIndex(true);
                            this.clean();
                        }
                        this.tree.index(tok, this.pre, pos, this.splits);
                        ++this.count;
                    }
                }
                ++this.pre;
            }
            this.write(this.splits > 0);
            this.finishIndex();
            return new FTIndex(this.data);
        }
        catch (Throwable th) {
            this.data.meta.drop("ftx.*");
            throw th;
        }
    }

    private void write(boolean partial) throws IOException {
        this.writeIndex(partial);
        if (!partial) {
            return;
        }
        try (DataOutput outX = new DataOutput(this.data.meta.dbfile("ftxx"));
             DataOutput outY = new DataOutput(this.data.meta.dbfile("ftxy"));
             DataOutput outZ = new DataOutput(this.data.meta.dbfile("ftxz"));){
            IntList ind = new IntList();
            FTList[] v = new FTList[this.splits];
            for (int b = 0; b < this.splits; ++b) {
                v[b] = new FTList(this.data, b);
            }
            IntList il = new IntList();
            while (FTBuilder.check(v)) {
                il.reset();
                int m = 0;
                il.add(m);
                for (int i = 0; i < this.splits; ++i) {
                    if (m == i || v[i].tok.length == 0) continue;
                    int l = v[i].tok.length - v[m].tok.length;
                    int d = Token.diff(v[m].tok, v[i].tok);
                    if (l < 0 || l == 0 && d > 0 || v[m].tok.length == 0) {
                        m = i;
                        il.reset();
                        il.add(m);
                        continue;
                    }
                    if (d != 0 || v[i].tok.length <= 0) continue;
                    il.add(i);
                }
                if (ind.isEmpty() || ind.get(ind.size() - 2) < v[m].tok.length) {
                    ind.add(v[m].tok.length);
                    ind.add((int)outY.size());
                }
                outY.writeBytes(v[m].tok);
                outY.write5(outZ.size());
                outY.write4(FTBuilder.merge(outZ, il, v));
            }
            FTBuilder.writeInd(outX, ind, ind.get(ind.size() - 2) + 1, (int)outY.size());
        }
    }

    private static void writeInd(DataOutput outX, IntList il, int ls, int lp) throws IOException {
        int is = il.size();
        outX.writeNum(is >> 1);
        for (int i = 0; i < is; i += 2) {
            outX.writeNum(il.get(i));
            outX.write4(il.get(i + 1));
        }
        outX.writeNum(ls);
        outX.write4(lp);
    }

    private void writeIndex(boolean partial) throws IOException {
        String name = "ftx" + (partial ? Integer.valueOf(this.splits) : "");
        try (DataOutput outX = new DataOutput(this.data.meta.dbfile(name + 'x'));
             DataOutput outY = new DataOutput(this.data.meta.dbfile(name + 'y'));
             DataOutput outZ = new DataOutput(this.data.meta.dbfile(name + 'z'));){
            IntList ind = new IntList();
            this.tree.init();
            long dr = 0L;
            int tr = 0;
            int j = 0;
            while (this.tree.more(this.splits)) {
                FTIndexTree t = this.tree.nextTree();
                t.next();
                byte[] key = t.nextTok();
                if (j < key.length) {
                    j = key.length;
                    ind.add(j);
                    ind.add(tr);
                }
                for (int i = 0; i < j; ++i) {
                    outY.write1(key[i]);
                }
                outY.write5(dr);
                outY.write4(t.nextNumPre());
                FTBuilder.writeFTData(outZ, t.nextPres(), t.nextPoss());
                dr = outZ.size();
                tr = (int)outY.size();
            }
            FTBuilder.writeInd(outX, ind, ++j, tr);
        }
        this.tree.initFT();
        ++this.splits;
    }

    private static int merge(DataOutput out, IntList il, FTList[] v) throws IOException {
        TokenBuilder tbp = new TokenBuilder();
        TokenBuilder tbo = new TokenBuilder();
        tbp.add(new byte[4]);
        tbo.add(new byte[4]);
        int s = 0;
        int is = il.size();
        for (int j = 0; j < is; ++j) {
            int m = il.get(j);
            for (int p : v[m].prv) {
                tbp.add(Num.num(p));
            }
            for (int p : v[m].pov) {
                tbo.add(Num.num(p));
            }
            s += v[m].size;
            v[m].next();
        }
        byte[] pr = tbp.finish();
        Num.size(pr, pr.length);
        byte[] po = tbo.finish();
        Num.size(po, po.length);
        FTBuilder.writeFTData(out, pr, po);
        return s;
    }

    private static void writeFTData(DataOutput out, byte[] vpre, byte[] vpos) throws IOException {
        int np = 4;
        int pp = 4;
        int ns = Num.size(vpre);
        while (np < ns) {
            int l = np + Num.length(vpre, np);
            while (np < l) {
                out.write(vpre[np]);
                ++np;
            }
            l = pp + Num.length(vpos, pp);
            while (pp < l) {
                out.write(vpos[pp]);
                ++pp;
            }
        }
    }

    private static boolean check(FTList[] lists) {
        for (FTList l : lists) {
            if (l.tok.length <= 0) continue;
            return true;
        }
        return false;
    }
}

