/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.table;

import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.Timer;
import java.util.TimerTask;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPanel;

final class TableInput {
    private final BaseXPanel panel;
    private final Timer timer;
    private String text;
    private boolean flashing;
    private int pos;

    TableInput(final BaseXPanel panel, String text) {
        this.panel = panel;
        this.text = text;
        this.pos = text.length();
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                TableInput.this.flashing = TableInput.this.flashing ^ true;
                panel.repaint();
            }
        }, 0L, 500L);
    }

    void stop() {
        this.timer.cancel();
        this.flashing = false;
        this.panel.repaint();
    }

    void paint(Graphics g, int x, int y, int w, int h) {
        g.setColor(GUIConstants.color4);
        g.drawRect(x, y - 1, w - 1, h);
        g.setColor(GUIConstants.TEXT);
        g.setFont(GUIConstants.font);
        g.drawString(this.text, x + 5, y + h - 7);
        int xx = x + BaseXLayout.width(g, this.text.substring(0, this.pos)) + 5;
        if (this.flashing) {
            g.drawLine(xx, y + 1, xx, y + h - 5);
        }
    }

    void code(KeyEvent e) {
        if (BaseXKeys.ENTER.is(e) || this.text == null) {
            this.stop();
        }
        this.flashing = true;
        if (BaseXKeys.LINESTART.is(e)) {
            this.pos = 0;
        } else if (BaseXKeys.LINEEND.is(e)) {
            this.pos = this.text.length();
        } else if (BaseXKeys.PREVCHAR.is(e)) {
            this.pos = Math.max(0, this.pos - 1);
        } else if (BaseXKeys.NEXTCHAR.is(e)) {
            this.pos = Math.min(this.text.length(), this.pos + 1);
        } else if (BaseXKeys.DELPREV.is(e)) {
            if (this.pos > 0) {
                this.text = this.text.substring(0, this.pos - 1) + this.text.substring(this.pos--);
            }
        } else if (BaseXKeys.DELNEXT.is(e) && this.pos < this.text.length()) {
            this.text = this.text.substring(0, this.pos) + this.text.substring(this.pos + 1);
        }
    }

    boolean add(KeyEvent e) {
        if (BaseXKeys.DELNEXT.is(e) || BaseXKeys.DELPREV.is(e)) {
            return true;
        }
        char ch = e.getKeyChar();
        if (ch < ' ') {
            return false;
        }
        this.flashing = true;
        this.text = this.text.substring(0, this.pos) + ch + this.text.substring(this.pos);
        ++this.pos;
        return true;
    }

    String text() {
        return this.text;
    }
}

