/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.project;

import java.io.IOException;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.basex.core.Context;
import org.basex.gui.view.project.ProjectCache;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.in.TextInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.util.InputInfo;
import org.basex.util.Performance;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenParser;
import org.basex.util.Util;
import org.basex.util.XMLToken;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;

final class ProjectFiles {
    private static final int MAXHITS = 256;
    private static long parseId;
    private static long filterId;
    private TreeMap<String, InputInfo> errors = new TreeMap();
    private ProjectCache cache;

    ProjectFiles() {
    }

    void reset() {
        this.cache = null;
        ++filterId;
        ++parseId;
    }

    TreeMap<String, InputInfo> errors() {
        return this.errors;
    }

    String[] filter(String files, String contents, IOFile root) throws InterruptedException {
        long id = ++filterId;
        StringList results = new StringList();
        int[] search = new TokenParser(Token.lc(Token.token(contents))).toArray();
        ProjectCache pc = this.cache(root);
        if (files.contains("*") || files.contains("?")) {
            Pattern pt = Pattern.compile(IOFile.regex(files));
            for (String path : pc) {
                if (pt.matcher(path).matches() && ProjectFiles.filterContent(path, search)) {
                    results.add(path);
                    if (results.size() >= 256) break;
                }
                if (id == filterId) continue;
                throw new InterruptedException();
            }
        } else {
            ProjectFiles.filter(files, search, id, results, pc);
        }
        return (String[])results.finish();
    }

    void parse(IOFile root, Context ctx) throws InterruptedException {
        long id = ++parseId;
        HashSet<String> parsed = new HashSet<String>();
        TreeMap<String, InputInfo> errs = new TreeMap<String, InputInfo>();
        ProjectCache pc = this.cache(root);
        StringList mods = new StringList();
        StringList lmods = new StringList();
        for (String path : pc) {
            IOFile file = new IOFile(path);
            if (!file.hasSuffix(IO.XQSUFFIXES)) continue;
            (file.hasSuffix(".xqm") ? lmods : mods).add(path);
        }
        mods.add(lmods);
        for (String path : mods) {
            if (id != parseId) {
                throw new InterruptedException();
            }
            if (parsed.contains(path)) continue;
            try {
                TextInput ti = new TextInput(new IOFile(path));
                Throwable throwable = null;
                try {
                    try {
                        QueryContext qc = new QueryContext(ctx);
                        Throwable throwable2 = null;
                        try {
                            String input = ti.cache().toString();
                            boolean lib = QueryProcessor.isLibrary(input);
                            qc.parse(input, lib, path, null);
                            parsed.add(path);
                            for (byte[] mod : qc.modParsed) {
                                parsed.add(Token.string(mod));
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (qc == null) continue;
                            if (throwable2 != null) {
                                try {
                                    qc.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            qc.close();
                        }
                    }
                    catch (QueryException ex) {
                        errs.put(path, ex.info());
                        parsed.add(path);
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (ti == null) continue;
                    if (throwable != null) {
                        try {
                            ti.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    ti.close();
                }
            }
            catch (IOException ex) {
                Util.debug(ex);
            }
        }
        this.errors = errs;
    }

    private ProjectCache cache(IOFile root) throws InterruptedException {
        ProjectCache pc = this.cache;
        if (pc == null) {
            this.cache = new ProjectCache();
            this.add(root, this.cache);
            this.cache.finish();
        } else {
            while (!pc.valid()) {
                Performance.sleep(1L);
                if (pc == this.cache) continue;
                throw new InterruptedException();
            }
        }
        return this.cache;
    }

    private void add(IOFile root, ProjectCache pc) throws InterruptedException {
        IOFile[] files;
        if (pc != this.cache) {
            throw new InterruptedException();
        }
        for (IOFile file : files = root.children()) {
            if (!file.name().equals(".ignore")) continue;
            return;
        }
        for (IOFile file : files) {
            if (file.isDir()) {
                this.add(file, pc);
                continue;
            }
            pc.add(file.path());
        }
    }

    private static void filter(String files, int[] search, long id, StringList results, ProjectCache cache) throws InterruptedException {
        String query = files.replace('\\', '/');
        HashSet<String> exclude = new HashSet<String>();
        for (boolean onlyName : new boolean[]{true, false}) {
            for (int mode = 0; mode < 5; ++mode) {
                for (String path : cache) {
                    String file;
                    if (exclude.contains(path)) continue;
                    String string = file = onlyName ? path.substring(path.lastIndexOf(47) + 1) : path;
                    if (mode == 0 ? Strings.startsWith(file, query) : (mode == 1 ? Strings.contains(file, query) : Strings.matches(file, query))) {
                        if (ProjectFiles.filterContent(path, search)) {
                            results.add(path);
                            if (results.size() >= 256) {
                                return;
                            }
                        }
                        exclude.add(path);
                    }
                    if (id == filterId) continue;
                    throw new InterruptedException();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean filterContent(String path, int[] search) {
        int cl = search.length;
        if (cl == 0) {
            return true;
        }
        try (TextInput ti = new TextInput(new IOFile(path));){
            IntList il = new IntList(cl - 1);
            int c = 0;
            while (true) {
                block24: {
                    if (!il.isEmpty()) {
                        if (il.remove(0) == search[c++]) continue;
                        c = 0;
                    }
                    do {
                        int cp;
                        if ((cp = ti.read()) == -1 || !XMLToken.valid(cp)) {
                            boolean bl = false;
                            return bl;
                        }
                        int lc = Token.lc(cp);
                        if (c > 0) {
                            il.add(lc);
                        }
                        if (lc != search[c]) break block24;
                    } while (++c != cl);
                    boolean bl = true;
                    return bl;
                }
                c = 0;
                continue;
                break;
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
            return false;
        }
    }
}

