/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractButton;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.text.ReplaceContext;
import org.basex.gui.text.SearchContext;
import org.basex.gui.text.TextPanel;
import org.basex.util.Util;

public final class SearchBar
extends BaseXBack {
    private final KeyListener escape = e -> {
        if (BaseXKeys.ESCAPE.is(e)) {
            this.deactivate(true);
        }
    };
    final AbstractButton regex;
    final AbstractButton mcase;
    final AbstractButton word;
    final AbstractButton multi;
    private final AbstractButton rplc;
    private final AbstractButton cls;
    private final GUI gui;
    private final BaseXCombo search;
    private final BaseXCombo replace;
    private AbstractButton button;
    private TextPanel editor;
    private String oldSearch = "";

    SearchBar(GUI gui) {
        String[] replaced;
        this.gui = gui;
        this.layout(new BorderLayout(2, 0));
        this.setOpaque(false);
        this.setVisible(false);
        this.search = new BaseXCombo((BaseXWindow)gui, true, new String[0]).history(GUIOptions.SEARCHED, gui.gopts);
        this.search.hint(Text.FIND + "...");
        this.replace = new BaseXCombo((BaseXWindow)gui, true, new String[0]).history(GUIOptions.REPLACED, gui.gopts);
        this.replace.hint(Text.REPLACE_WITH + "...");
        ActionListener action = e -> {
            this.refreshButtons();
            this.search();
        };
        this.mcase = this.button("f_case", Text.MATCH_CASE, action);
        this.word = this.button("f_word", Text.WHOLE_WORD, action);
        this.regex = this.button("f_regex", Text.REGULAR_EXPR, action);
        this.multi = this.button("f_multi", Text.MULTI_LINE, action);
        this.rplc = BaseXButton.get("f_replace", Text.REPLACE_ALL, false, gui);
        this.cls = BaseXButton.get("f_close", BaseXLayout.addShortcut(Text.CLOSE, BaseXKeys.ESCAPE.toString()), false, gui);
        this.search.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (BaseXKeys.FINDPREV1.is(e) || BaseXKeys.FINDPREV2.is(e) || BaseXKeys.FINDNEXT1.is(e) || BaseXKeys.FINDNEXT2.is(e)) {
                    ((SearchBar)SearchBar.this).editor.editor.noSelect();
                    SearchBar.this.deactivate(false);
                } else if (BaseXKeys.ESCAPE.is(e)) {
                    SearchBar.this.deactivate(SearchBar.this.search.getText().isEmpty());
                } else if (BaseXKeys.ENTER.is(e)) {
                    SearchBar.this.search.updateHistory();
                    SearchBar.this.editor.jump(SearchDir.FORWARD, true);
                } else if (BaseXKeys.SHIFT_ENTER.is(e)) {
                    SearchBar.this.editor.jump(SearchDir.BACKWARD, true);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                String srch = SearchBar.this.search.getText();
                if (!SearchBar.this.oldSearch.equals(srch)) {
                    if (SearchBar.this.regex.isEnabled() && SearchBar.this.search.getText().matches("^.*(?<!\\\\)\\\\n.*")) {
                        SearchBar.this.multi.setSelected(true);
                    }
                    SearchBar.this.oldSearch = srch;
                    SearchBar.this.search();
                }
            }
        });
        BaseXLayout.addDrop(this.search, object -> {
            this.setSearch(object.toString());
            this.search.updateHistory();
            this.search();
        });
        this.replace.addKeyListener(this.escape);
        this.cls.addKeyListener(this.escape);
        this.cls.addActionListener(e -> this.deactivate(true));
        this.rplc.addKeyListener(this.escape);
        this.rplc.addActionListener(e -> {
            String in = this.replace.getText();
            this.editor.replace(new ReplaceContext(this.regex.isSelected() ? SearchBar.decode(in) : in));
            this.deactivate(true);
        });
        String[] searched = gui.gopts.get(GUIOptions.SEARCHED);
        if (searched.length > 0) {
            this.setSearch(searched[0]);
        }
        if ((replaced = gui.gopts.get(GUIOptions.REPLACED)).length > 0) {
            this.replace.setText(replaced[0]);
        }
    }

    public void editor(TextPanel text, boolean srch) {
        boolean ed = text.isEditable();
        if (this.editor == null || ed != this.editor.isEditable()) {
            this.removeAll();
            BaseXBack west = new BaseXBack(false).layout(new TableLayout(1, 4, 1, 0));
            west.add(this.mcase);
            west.add(this.word);
            west.add(this.regex);
            west.add(this.multi);
            BaseXBack center = new BaseXBack(false).layout(new GridLayout(1, 2, 2, 0));
            center.add(this.search);
            if (ed) {
                center.add(this.replace);
            }
            BaseXBack east = new BaseXBack(false).layout(new TableLayout(1, 3, 1, 0));
            if (ed) {
                east.add(this.rplc);
            }
            east.add(this.cls);
            this.add((Component)west, "West");
            this.add((Component)center, "Center");
            this.add((Component)east, "East");
        }
        this.editor = text;
        this.refreshLayout();
        text.setSearch(this);
        if (srch) {
            this.search(false);
        }
    }

    public AbstractButton button(String help) {
        this.button = BaseXButton.get("c_find", BaseXLayout.addShortcut(help, BaseXKeys.FIND.toString()), true, this.gui);
        this.button.addActionListener(e -> {
            if (this.isVisible()) {
                this.deactivate(true);
            } else {
                this.activate("", true);
            }
        });
        return this.button;
    }

    public void refreshLayout() {
        if (this.editor == null) {
            return;
        }
        Font ef = this.editor.getFont().deriveFont((float)GUIConstants.dmfont.getSize() + 2.0f);
        this.search.setFont(ef);
        this.replace.setFont(ef);
    }

    public void activate(String string, boolean focus) {
        boolean invisible;
        boolean bl = invisible = !this.isVisible();
        if (invisible) {
            this.setVisible(true);
            if (this.button != null) {
                this.button.setSelected(true);
            }
        }
        if (focus) {
            this.search.requestFocusInWindow();
        }
        if (!string.isEmpty() && !new SearchContext(this, this.search.getText()).matches(string)) {
            this.regex.setSelected(false);
            this.setSearch(string);
            this.search.updateHistory();
            invisible = true;
        }
        if (invisible) {
            this.search();
        }
    }

    public boolean deactivate(boolean close) {
        this.editor.requestFocusInWindow();
        if (!close || !this.isVisible()) {
            return false;
        }
        this.setVisible(false);
        if (this.button != null) {
            this.button.setSelected(false);
        }
        this.search();
        return true;
    }

    void refresh(SearchContext sc, boolean jump) {
        boolean hits = sc.nr != 0;
        boolean empty = sc.string.isEmpty();
        this.rplc.setEnabled(hits && !empty);
        this.search.highlight(hits || empty);
        if (this.isVisible()) {
            this.gui.status.setText(Util.info(Text.STRINGS_FOUND_X, sc.nr()));
        }
        if (jump) {
            this.editor.jump(SearchDir.CURRENT, false);
        }
    }

    private void setSearch(String text) {
        this.oldSearch = this.search.getText();
        this.search.setText(text);
    }

    private void refreshButtons() {
        boolean sel = this.regex.isSelected();
        this.multi.setEnabled(sel);
        this.word.setEnabled(!sel);
    }

    private void search() {
        this.search(true);
    }

    private void search(boolean jump) {
        String text;
        String string = text = this.isVisible() ? this.search.getText() : "";
        if (!text.isEmpty()) {
            this.gui.status.setText(Text.SEARCHING + "...");
        }
        this.editor.search(new SearchContext(this, text), jump);
    }

    private AbstractButton button(String icon, String tooltip, ActionListener action) {
        AbstractButton b = BaseXButton.get(icon, tooltip, true, this.gui);
        b.addKeyListener(this.escape);
        b.addActionListener(action);
        return b;
    }

    private static String decode(String in) {
        StringBuilder sb = new StringBuilder();
        boolean bs = false;
        int is = in.length();
        for (int i = 0; i < is; ++i) {
            char ch = in.charAt(i);
            if (bs) {
                if (ch == 'n') {
                    sb.append('\n');
                } else if (ch == 't') {
                    sb.append('\t');
                } else {
                    sb.append('\\');
                    if (ch != '\\') {
                        sb.append(ch);
                    }
                }
                bs = false;
                continue;
            }
            if (ch == '\\') {
                bs = true;
                continue;
            }
            sb.append(ch);
        }
        if (bs) {
            sb.append('\\');
        }
        return sb.toString();
    }

    public static enum SearchDir {
        CURRENT,
        FORWARD,
        BACKWARD;

    }
}

