/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.io.File;
import java.util.Locale;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.basex.core.Text;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXWindow;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.util.Util;

public final class BaseXFileChooser {
    private final BaseXWindow win;
    private final JFileChooser fc;
    private String suffix;

    public BaseXFileChooser(BaseXWindow win, String title, String path) {
        this.win = win;
        IOFile file = new IOFile(path);
        this.fc = new JFileChooser(path);
        if (!file.isDir()) {
            this.fc.setSelectedFile(file.file());
        }
        this.fc.setDialogTitle(title);
    }

    public BaseXFileChooser textFilters() {
        this.filter("XML Documents", IO.XMLSUFFIXES);
        this.filter("XSL Documents", IO.XSLSUFFIXES);
        this.filter("HTML Documents", IO.HTMLSUFFIXES);
        this.filter("JSON Documents", ".json");
        this.filter("CSV Documents", ".csv");
        this.filter("Plain Text", IO.TXTSUFFIXES);
        return this;
    }

    public BaseXFileChooser filter(String dsc, String ... suf) {
        if (this.fc != null) {
            FileFilter ff = this.fc.getFileFilter();
            this.fc.addChoosableFileFilter(new Filter(suf, dsc));
            this.fc.setFileFilter(ff);
        }
        return this;
    }

    public BaseXFileChooser suffix(String suf) {
        this.suffix = suf;
        return this;
    }

    public BaseXFileChooser multi() {
        if (this.fc != null) {
            this.fc.setMultiSelectionEnabled(true);
        }
        return this;
    }

    public IOFile select(Mode mode) {
        IOFile[] files = this.selectAll(mode);
        return files.length == 0 ? null : files[0];
    }

    public IOFile[] selectAll(Mode mode) {
        File[] fileArray;
        int state = 0;
        switch (mode) {
            case FOPEN: {
                state = this.fc.showOpenDialog(this.win.component());
                break;
            }
            case FDOPEN: {
                this.fc.setFileSelectionMode(2);
                state = this.fc.showOpenDialog(this.win.component());
                break;
            }
            case FSAVE: {
                state = this.fc.showSaveDialog(this.win.component());
                break;
            }
            case DOPEN: 
            case DSAVE: {
                this.fc.setFileSelectionMode(1);
                state = this.fc.showDialog(this.win.component(), null);
            }
        }
        if (state != 0) {
            return new IOFile[0];
        }
        if (this.fc.isMultiSelectionEnabled()) {
            fileArray = this.fc.getSelectedFiles();
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = this.fc.getSelectedFile();
        }
        File[] fls = fileArray;
        int fl = fls.length;
        IOFile[] files = new IOFile[fl];
        for (int f = 0; f < fl; ++f) {
            String path = fls[f].getPath();
            files[f] = new IOFile(path.substring(0, Math.min(path.length(), 512)));
        }
        if (mode == Mode.FSAVE) {
            FileFilter ff = this.fc.getFileFilter();
            if (this.suffix != null) {
                for (int f = 0; f < fl; ++f) {
                    String path = files[f].path();
                    if (path.contains(".")) continue;
                    files[f] = new IOFile(path + this.suffix);
                }
            } else if (ff instanceof Filter) {
                String[] sufs = ((Filter)ff).sufs;
                int sl = sufs.length;
                for (int f = 0; f < fl && sl != 0; ++f) {
                    String path = files[f].path();
                    if (path.contains(".")) continue;
                    files[f] = new IOFile(path + sufs[0]);
                }
            }
            for (IOFile io : files) {
                if (!io.exists() || BaseXDialog.confirm(this.win.gui(), Util.info(Text.FILE_EXISTS_X, io))) continue;
                return new IOFile[0];
            }
        }
        return files;
    }

    private static class Filter
    extends FileFilter {
        final String[] sufs;
        final String desc;

        Filter(String[] s, String d) {
            this.sufs = s;
            this.desc = d;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName().toLowerCase(Locale.ENGLISH);
            for (String s : this.sufs) {
                if (!name.endsWith(s)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            StringBuilder sb = new StringBuilder();
            for (String s : this.sufs) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append('*').append(s);
            }
            return this.desc + " (" + sb + ')';
        }
    }

    public static enum Mode {
        FOPEN,
        FDOPEN,
        DOPEN,
        FSAVE,
        DSAVE;

    }
}

