/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.SwingUtilities;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.text.TextPanel;

public final class DialogMessage
extends BaseXDialog {
    private String action;

    public DialogMessage(GUI gui, String txt, GUIConstants.Msg ic, String ... buttons) {
        super(gui, ic == GUIConstants.Msg.ERROR ? Text.ERROR : Text.INFORMATION);
        this.panel.setLayout(new BorderLayout());
        BaseXBack back = new BaseXBack(new TableLayout(1, 2, 12, 0));
        BaseXLabel label = new BaseXLabel();
        label.setIcon(ic.large);
        back.add(label);
        TextPanel tp = new TextPanel(this, txt.replaceAll("(.{1,160})", "$1").trim(), false);
        tp.setFont(label.getFont());
        back.add(tp);
        this.set(back, "North");
        ArrayList<String> list = new ArrayList<String>();
        if (ic == GUIConstants.Msg.QUESTION || ic == GUIConstants.Msg.YESNOCANCEL) {
            list.add(Text.B_YES);
            list.add(Text.B_NO);
            Collections.addAll(list, buttons);
            if (ic == GUIConstants.Msg.YESNOCANCEL) {
                list.add(Text.B_CANCEL);
            }
        } else {
            Collections.addAll(list, buttons);
            list.add(Text.B_OK);
        }
        BaseXBack bttns = this.newButtons(list.toArray(new Object[list.size()]));
        this.set(bttns, "South");
        SwingUtilities.invokeLater(((Container)bttns.getComponent(0)).getComponent(0)::requestFocusInWindow);
        this.finish();
    }

    @Override
    public void action(Object cmp) {
        BaseXButton button = (BaseXButton)cmp;
        String text = button.getText();
        if (text.equals(Text.B_CANCEL)) {
            this.cancel();
        }
        this.action = text;
        if (text.equals("no")) {
            this.cancel();
        } else {
            this.close();
        }
    }

    public String action() {
        return this.action;
    }
}

