/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.util.Date;
import java.util.Locale;
import org.basex.data.MetaData;
import org.basex.util.DateTime;

public enum MetaProp {
    NAME(false){

        @Override
        public String value(MetaData meta) {
            return meta.name;
        }
    }
    ,
    SIZE(false){

        @Override
        public Long value(MetaData meta) {
            return meta.dbsize();
        }
    }
    ,
    NODES(false){

        @Override
        public Integer value(MetaData meta) {
            return meta.size;
        }
    }
    ,
    DOCUMENTS(false){

        @Override
        public Integer value(MetaData meta) {
            return meta.ndocs;
        }
    }
    ,
    BINARIES(false){

        @Override
        public Integer value(MetaData meta) {
            return meta.path != null ? meta.binaries().descendants().size() : 0;
        }
    }
    ,
    TIMESTAMP(false){

        @Override
        public String value(MetaData meta) {
            return DateTime.format(new Date(meta.dbtime()));
        }
    }
    ,
    UPTODATE(false){

        @Override
        public Boolean value(MetaData meta) {
            return meta.uptodate;
        }
    }
    ,
    INPUTPATH(false){

        @Override
        public String value(MetaData meta) {
            return meta.original;
        }
    }
    ,
    INPUTSIZE(false){

        @Override
        public Long value(MetaData meta) {
            return meta.filesize;
        }
    }
    ,
    INPUTDATE(false){

        @Override
        public String value(MetaData meta) {
            return DateTime.format(new Date(meta.time));
        }
    }
    ,
    TEXTINDEX(true){

        @Override
        public Boolean value(MetaData meta) {
            return meta.textindex;
        }
    }
    ,
    ATTRINDEX(true){

        @Override
        public Boolean value(MetaData meta) {
            return meta.attrindex;
        }
    }
    ,
    TOKENINDEX(true){

        @Override
        public Boolean value(MetaData meta) {
            return meta.tokenindex;
        }
    }
    ,
    FTINDEX(true){

        @Override
        public Boolean value(MetaData meta) {
            return meta.ftindex;
        }
    }
    ,
    TEXTINCLUDE(true){

        @Override
        public String value(MetaData meta) {
            return meta.textinclude;
        }
    }
    ,
    ATTRINCLUDE(true){

        @Override
        public String value(MetaData meta) {
            return meta.attrinclude;
        }
    }
    ,
    TOKENINCLUDE(true){

        @Override
        public String value(MetaData meta) {
            return meta.tokeninclude;
        }
    }
    ,
    FTINCLUDE(true){

        @Override
        public String value(MetaData meta) {
            return meta.ftinclude;
        }
    }
    ,
    LANGUAGE(true){

        @Override
        public String value(MetaData meta) {
            return meta.language.toString();
        }
    }
    ,
    STEMMING(true){

        @Override
        public Boolean value(MetaData meta) {
            return meta.stemming;
        }
    }
    ,
    CASESENS(true){

        @Override
        public Boolean value(MetaData meta) {
            return meta.casesens;
        }
    }
    ,
    DIACRITICS(true){

        @Override
        public Boolean value(MetaData meta) {
            return meta.diacritics;
        }
    }
    ,
    STOPWORDS(true){

        @Override
        public String value(MetaData meta) {
            return meta.stopwords;
        }
    }
    ,
    UPDINDEX(true){

        @Override
        public Boolean value(MetaData meta) {
            return meta.updindex;
        }
    }
    ,
    AUTOOPTIMIZE(true){

        @Override
        public Boolean value(MetaData meta) {
            return meta.autooptimize;
        }
    }
    ,
    MAXCATS(true){

        @Override
        public Integer value(MetaData meta) {
            return meta.maxcats;
        }
    }
    ,
    MAXLEN(true){

        @Override
        public Integer value(MetaData meta) {
            return meta.maxlen;
        }
    }
    ,
    SPLITSIZE(true){

        @Override
        public Integer value(MetaData meta) {
            return meta.splitsize;
        }
    };

    public final boolean index;
    public static final MetaProp[] VALUES;

    private MetaProp(boolean index) {
        this.index = index;
    }

    public abstract Object value(MetaData var1);

    public static MetaProp get(String name) {
        for (MetaProp prop : VALUES) {
            if (!prop.toString().toLowerCase(Locale.ENGLISH).equals(name)) continue;
            return prop;
        }
        return null;
    }

    static {
        VALUES = MetaProp.values();
    }
}

