/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.parse;

import java.util.Locale;
import org.basex.core.Command;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class CmdBuilder {
    private final TokenBuilder tb = new TokenBuilder();
    private final Command cmd;
    private final boolean conf;

    public CmdBuilder(Command cmd, boolean conf) {
        this.cmd = cmd;
        this.conf = conf;
    }

    public CmdBuilder init() {
        this.init(Util.className(this.cmd).toUpperCase(Locale.ENGLISH));
        return this;
    }

    public CmdBuilder init(String string) {
        this.tb.reset().add(string);
        return this;
    }

    public CmdBuilder args() {
        int as = this.cmd.args.length;
        for (int a = 0; a < as; ++a) {
            this.arg(a);
        }
        return this;
    }

    public CmdBuilder xquery(int arg) {
        this.tb.add(32).add(this.cmd.args[arg]);
        return this;
    }

    public boolean conf() {
        return this.conf;
    }

    public CmdBuilder arg(int arg) {
        this.arg(null, arg);
        return this;
    }

    public CmdBuilder arg(String key, int arg) {
        return this.arg(key, this.cmd.args.length > arg ? this.cmd.args[arg] : null);
    }

    public CmdBuilder arg(String key, String arg) {
        if (arg != null && !arg.isEmpty()) {
            if (key != null) {
                this.tb.add(32).add(key);
            }
            this.tb.add(32);
            if (arg.indexOf(32) != -1 || arg.indexOf(59) != -1) {
                this.tb.add(34).add(arg.replaceAll("\"", "\\\"")).add(34);
            } else {
                this.tb.add(arg);
            }
        }
        return this;
    }

    public String toString() {
        return this.tb.toString();
    }
}

