/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.locks;

import java.util.Iterator;
import org.basex.util.Strings;
import org.basex.util.list.StringList;

public final class LockList
implements Iterable<String> {
    private final StringList list = new StringList(0);
    private boolean global;

    public LockList add(String lock) {
        if (!this.global) {
            this.list.add(lock);
        }
        return this;
    }

    public boolean local() {
        return !this.list.isEmpty();
    }

    public void addGlobal() {
        this.global = true;
        this.list.reset();
    }

    public void reset() {
        this.global = false;
        this.list.reset();
    }

    public boolean global() {
        return this.global;
    }

    public boolean locking() {
        return this.global() || this.local();
    }

    public void add(LockList locks) {
        if (!this.global) {
            if (locks.global) {
                this.addGlobal();
            } else {
                this.list.add(locks.list);
            }
        }
    }

    public void remove(LockList locks) {
        this.list.delete(locks.list);
    }

    public String get(int index) {
        return (String)this.list.get(index);
    }

    public boolean contains(String lock) {
        return this.list.contains(lock);
    }

    public int size() {
        return this.list.size();
    }

    public void finish(String name) {
        for (int s = 0; s < this.list.size(); ++s) {
            String lock = (String)this.list.get(s);
            if (!Strings.eq(lock, "%COLLECTION", "%CONTEXT")) continue;
            if (name == null) {
                this.list.remove(s--);
                continue;
            }
            this.list.set(s, name);
        }
        this.list.sort().unique();
    }

    @Override
    public Iterator<String> iterator() {
        return this.list.iterator();
    }

    public String toString() {
        return this.global ? "(global)" : (this.list.isEmpty() ? "(none)" : String.join((CharSequence)",", (CharSequence[])this.list.toArray()));
    }
}

