/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.jobs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.basex.build.Parser;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.jobs.JobsOptions;
import org.basex.core.jobs.JobsText;
import org.basex.core.jobs.QueryJob;
import org.basex.core.jobs.QueryJobSpec;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.XMLAccess;
import org.basex.util.options.Option;

public final class Jobs {
    private static final Object FILE = new Object();
    private final ArrayList<QueryJobSpec> list = new ArrayList();
    private final Context context;
    private final IOFile file;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Jobs(Context context) throws IOException {
        IOContent content;
        this.context = context;
        this.file = context.soptions.dbPath(Token.string(JobsText.JOBS) + ".xml");
        Object object = FILE;
        synchronized (object) {
            if (!this.file.exists()) {
                return;
            }
            content = new IOContent(this.file.read(), this.file.path());
        }
        MainOptions options = new MainOptions(false);
        options.set(MainOptions.INTPARSE, true);
        DBNode doc = new DBNode(Parser.singleParser(content, options, ""));
        ANode root = XMLAccess.children(doc, JobsText.JOBS).next();
        if (root == null) {
            Util.errln(this.file + ": No '%' root element.", new Object[]{JobsText.JOBS});
        } else {
            for (ANode child : XMLAccess.children(root)) {
                byte[] qname = child.qname().id();
                if (Token.eq(qname, JobsText.JOB)) {
                    JobsOptions opts = this.options(child);
                    if (opts == null) continue;
                    HashMap<String, Value> bindings = new HashMap<String, Value>();
                    this.add(new QueryJobSpec(opts, bindings, Token.string(child.string())));
                    continue;
                }
                Util.errln(this.file + ": invalid element: %.", new Object[]{qname});
            }
        }
    }

    public void add(QueryJobSpec spec) {
        for (int l = 0; l < this.list.size(); ++l) {
            QueryJobSpec job = this.list.get(l);
            if (!job.equals(spec)) continue;
            this.list.set(l, job);
            return;
        }
        this.list.add(spec);
    }

    public void remove(String id) {
        for (int l = 0; l < this.list.size(); ++l) {
            QueryJobSpec spec = this.list.get(l);
            if (!id.equals(spec.options.get(JobsOptions.ID))) continue;
            this.list.remove(l);
        }
    }

    public void run() {
        boolean error = false;
        for (int l = 0; l < this.list.size(); ++l) {
            QueryJobSpec spec = this.list.get(l);
            try {
                new QueryJob(spec, null, this.context);
                continue;
            }
            catch (QueryException ex) {
                Util.errln(ex, new Object[0]);
                this.list.remove(l);
                error = true;
            }
        }
        if (error) {
            try {
                this.write();
            }
            catch (IOException ex) {
                Util.errln(this.file + ": %", ex);
            }
        }
    }

    private JobsOptions options(ANode job) {
        JobsOptions opts = new JobsOptions();
        for (ANode attr : job.attributes()) {
            try {
                opts.assign(Token.string(attr.name()), Token.string(attr.string()));
            }
            catch (BaseXException ex) {
                Util.errln(this.file + ": Job attribute cannot be assigned: %", ex);
                return null;
            }
        }
        return opts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        FElem xml = this.toXML();
        Object object = FILE;
        synchronized (object) {
            if (this.list.isEmpty() && this.file.exists()) {
                this.file.delete();
                return;
            }
            this.file.parent().md();
            this.file.write(xml.serialize().finish());
        }
    }

    public FElem toXML() {
        FElem root = new FElem(JobsText.JOBS);
        for (QueryJobSpec spec : this.list) {
            FElem elem = new FElem(JobsText.JOB);
            for (Option<?> option : spec.options) {
                Object value = spec.options.get(option);
                if (value == null) continue;
                elem.add(option.name(), value.toString());
            }
            root.add(elem.add(spec.query));
        }
        return root;
    }
}

