/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Databases;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.cmd.ABackup;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.core.users.Perm;
import org.basex.io.IOFile;
import org.basex.util.list.StringList;

public final class DropBackup
extends ABackup {
    public DropBackup(String name) {
        super(name);
    }

    @Override
    protected boolean run() {
        String name = this.args[0];
        if (!Databases.validName(name, true)) {
            return this.error(Text.NAME_INVALID_X, name);
        }
        StringList dbs = this.context.listDBs(name);
        if (dbs.isEmpty() && this.context.perm(Perm.READ, name)) {
            dbs.add(name);
        }
        for (String db : dbs) {
            for (String backup : this.context.databases.backups(db)) {
                DropBackup.drop(backup, this.soptions);
            }
        }
        return this.info(Text.BACKUP_DROPPED_X, name + '*' + ".zip");
    }

    public static boolean drop(String name, StaticOptions sopts) {
        return new IOFile(sopts.dbPath(), name + ".zip").delete();
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.DROP) + " " + (Object)((Object)Commands.CmdDrop.BACKUP)).args();
    }
}

