/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.text;

import java.io.IOException;
import org.basex.build.SingleParser;
import org.basex.build.text.TextOptions;
import org.basex.core.MainOptions;
import org.basex.io.IO;
import org.basex.io.in.NewlineInput;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;

public final class TextParser
extends SingleParser {
    private static final byte[] TEXT = Token.token("text");
    private static final byte[] LINE = Token.token("line");
    private final boolean lines;
    private final String encoding;

    public TextParser(IO source, MainOptions opts) {
        super(source, opts);
        TextOptions topts = opts.get(MainOptions.TEXTPARSER);
        this.lines = topts.get(TextOptions.LINES);
        this.encoding = topts.get(TextOptions.ENCODING);
    }

    @Override
    public void parse() throws IOException {
        this.builder.openElem(TEXT, this.atts, this.nsp);
        TokenBuilder tb = new TokenBuilder();
        try (NewlineInput nli = new NewlineInput(this.source);){
            int ch;
            nli.encoding(this.encoding);
            while ((ch = nli.read()) != -1) {
                if (ch == 10 && this.lines) {
                    this.builder.openElem(LINE, this.atts, this.nsp);
                    this.builder.text(tb.next());
                    this.builder.closeElem();
                    continue;
                }
                tb.add(XMLToken.valid(ch) ? ch : 65533);
            }
        }
        if (!this.lines) {
            this.builder.text(tb.finish());
        }
        this.builder.closeElem();
    }
}

