/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.basex.core.BaseXException;
import org.basex.http.HTTPConnection;
import org.basex.http.webdav.WebDAVQuery;
import org.basex.io.IOStream;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryProcessor;
import org.basex.query.value.item.Item;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.StringList;

final class WebDAVLockService {
    private static final String FILE = "xquery/webdav.xqm";
    private static String module;
    private final HTTPConnection conn;

    WebDAVLockService(HTTPConnection conn) {
        this.conn = conn;
    }

    void unlock(String token) throws IOException {
        this.execute(new WebDAVQuery("w:delete-lock($token)").bind("token", token));
    }

    void refreshLock(String token) throws IOException {
        this.execute(new WebDAVQuery("w:refresh-lock($token)").bind("token", token));
    }

    String lock(String db, String p, String scope, String type, String depth, String user, Long to) throws IOException {
        this.initLockDb();
        String token = UUID.randomUUID().toString();
        WebDAVQuery query = new WebDAVQuery("w:create-lock($path, $token, $scope, $type, $depth, $owner, $timeout)");
        query.bind("path", db + '/' + p);
        query.bind("token", token);
        query.bind("scope", scope);
        query.bind("type", type);
        query.bind("depth", depth);
        query.bind("owner", user);
        query.bind("timeout", to == null ? Long.toString(Long.MAX_VALUE) : to.toString());
        this.execute(query);
        return token;
    }

    String lock(String token) throws IOException {
        StringList locks = this.execute(new WebDAVQuery("w:lock($token)").bind("token", token));
        return locks.isEmpty() ? null : (String)locks.get(0);
    }

    String lock(String db, String path) throws IOException {
        WebDAVQuery query = new WebDAVQuery("w:locks-on($path)").bind("path", db + '/' + path);
        StringList sl = this.execute(query);
        return sl.isEmpty() ? null : (String)sl.get(0);
    }

    boolean conflictingLocks(String db, String p) throws IOException {
        return !this.execute(new WebDAVQuery("w:conflicting-locks(<w:lockinfo><w:path>{ $path }</w:path><w:scope>exclusive</w:scope><w:depth>infinity</w:depth><w:owner>{ $owner }</w:owner></w:lockinfo>)").bind("path", db + '/' + p).bind("owner", this.conn.context.user().name())).isEmpty();
    }

    private void initLockDb() throws IOException {
        this.execute(new WebDAVQuery("w:init-lock-db()"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StringList execute(WebDAVQuery query) throws IOException {
        if (module == null) {
            ClassLoader cl = this.getClass().getClassLoader();
            InputStream is = cl.getResourceAsStream(FILE);
            if (is == null) {
                throw new IOException("WebDAV module not found: xquery/webdav.xqm");
            }
            module = Token.string((byte[])new IOStream(is).read());
        }
        try (QueryProcessor qp = new QueryProcessor(query.toString(), this.conn.context);){
            for (Map.Entry<String, String> entry : query.entries()) {
                qp.bind(entry.getKey(), (Object)entry.getValue());
            }
            qp.qc.parseLibrary(module, FILE, qp.sc);
            StringList items = new StringList();
            ArrayOutput ao = new ArrayOutput();
            Serializer ser = qp.getSerializer((OutputStream)ao);
            for (Item item : qp.value()) {
                ser.serialize(item);
                items.add((Object)ao.toString());
                ao.reset();
            }
            Iterator iterator = items;
            return iterator;
        }
        catch (Exception ex) {
            Util.errln((Object)ex.getMessage(), (Object[])new Object[0]);
            throw new BaseXException(ex);
        }
    }
}

