/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import org.basex.core.Context;
import org.basex.http.HTTPCode;
import org.basex.http.HTTPConnection;
import org.basex.http.rest.RESTCmd;
import org.basex.http.rest.RESTCommand;
import org.basex.http.rest.RESTQuery;
import org.basex.http.rest.RESTRun;
import org.basex.http.rest.RESTScript;
import org.basex.http.rest.RESTSession;
import org.basex.http.rest.RESTText;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.in.NewlineInput;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.util.DataBuilder;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.util.Token;

final class RESTPost {
    private RESTPost() {
    }

    public static RESTCmd get(RESTSession session) throws IOException {
        DBNode doc;
        HTTPConnection conn = session.conn;
        String encoding = conn.req.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try (NewlineInput ni = new NewlineInput((InputStream)conn.req.getInputStream());){
            doc = new DBNode((IO)new IOContent(ni.encoding(encoding).content()));
        }
        catch (IOException ex) {
            throw HTTPCode.BAD_REQUEST_X.get(ex);
        }
        try {
            String value;
            String name;
            Context ctx = conn.context;
            String cmd = RESTPost.value("local-name(*)", (Item)doc, ctx);
            if (cmd.equals("commands")) {
                String script = DataBuilder.stripNS((ANode)doc, (byte[])RESTText.REST_URI, (Context)ctx).serialize().toString();
                return RESTScript.get(session, script);
            }
            SerializerOptions sopts = conn.sopts();
            try (QueryProcessor qp = new QueryProcessor("*/*:parameter", ctx).context((Value)doc);){
                for (Item param : qp.value()) {
                    name = RESTPost.value("@name", param, ctx);
                    value = RESTPost.value("@value", param, ctx);
                    if (sopts.option(name) != null) {
                        sopts.assign(name, value);
                        continue;
                    }
                    throw HTTPCode.UNKNOWN_PARAM_X.get(name);
                }
            }
            qp = new QueryProcessor("*/*:option", ctx).context((Value)doc);
            var8_15 = null;
            try {
                for (Item item : qp.value()) {
                    name = RESTPost.value("@name", item, ctx).toUpperCase(Locale.ENGLISH);
                    value = RESTPost.value("@value", item, ctx);
                    ctx.options.assign(name, value);
                }
            }
            catch (Throwable throwable) {
                var8_15 = throwable;
                throw throwable;
            }
            finally {
                if (qp != null) {
                    if (var8_15 != null) {
                        try {
                            qp.close();
                        }
                        catch (Throwable throwable) {
                            var8_15.addSuppressed(throwable);
                        }
                    } else {
                        qp.close();
                    }
                }
            }
            HashMap<String, String[]> vars = new HashMap<String, String[]>();
            QueryProcessor qp = new QueryProcessor("*/*:variable", ctx).context((Value)doc);
            Object object = null;
            try {
                for (Item item : qp.value()) {
                    String name2 = RESTPost.value("@name", item, ctx);
                    String value2 = RESTPost.value("@value", item, ctx);
                    String type = RESTPost.value("@type", item, ctx);
                    vars.put(name2, new String[]{value2, type});
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (qp != null) {
                    if (object != null) {
                        try {
                            qp.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        qp.close();
                    }
                }
            }
            String val = null;
            QueryProcessor qp2 = new QueryProcessor("*/*:context/(*, text()[normalize-space()])", ctx).context((Value)doc);
            Object object2 = null;
            try {
                for (Item item : qp2.value()) {
                    if (val != null) {
                        throw HTTPCode.MULTIPLE_CONTEXT_X.get(new Object[0]);
                    }
                    val = DataBuilder.stripNS((ANode)((ANode)item), (byte[])RESTText.REST_URI, (Context)ctx).serialize().toString();
                }
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (qp2 != null) {
                    if (object2 != null) {
                        try {
                            qp2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        qp2.close();
                    }
                }
            }
            String text = RESTPost.value("*/*:text/text()", (Item)doc, ctx);
            if (cmd.equals("command")) {
                return RESTCommand.get(session, text);
            }
            if (cmd.equals("run")) {
                return RESTRun.get(session, text, vars, val);
            }
            if (cmd.equals("query")) {
                return RESTQuery.get(session, text, vars, val);
            }
            throw HTTPCode.BAD_REQUEST_X.get("Invalid POST command: " + cmd);
        }
        catch (QueryException ex) {
            throw HTTPCode.BAD_REQUEST_X.get(new Object[]{ex});
        }
    }

    private static String value(String query, Item value, Context ctx) throws QueryException {
        try (QueryProcessor qp = new QueryProcessor(query, ctx).context((Value)value);){
            Item item = qp.iter().next();
            String string = item == null ? "" : Token.string((byte[])item.string(null));
            return string;
        }
    }
}

