/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.basex.core.MainOptions;
import org.basex.http.HTTPConnection;
import org.basex.io.IOContent;
import org.basex.io.in.ArrayInput;
import org.basex.io.in.BufferInput;
import org.basex.query.QueryException;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Item;
import org.basex.util.Strings;
import org.basex.util.http.HttpPayload;
import org.basex.util.http.MediaType;

public final class HTTPParams {
    private final HTTPConnection conn;
    private Map<String, String[]> strings;
    private Map<String, Value> values;
    private Map<String, Value> form;
    private IOContent content;

    HTTPParams(HTTPConnection conn) {
        this.conn = conn;
    }

    public Map<String, String[]> stringMap() throws IOException {
        try {
            if (this.strings == null) {
                this.strings = this.conn.req.getParameterMap();
            }
            return this.strings;
        }
        catch (IllegalStateException ex) {
            throw new IOException(ex);
        }
    }

    public Map<String, Value> form(MainOptions options) throws QueryException, IOException {
        if (this.form == null) {
            this.form = new HashMap<String, Value>();
            MediaType mt = this.conn.contentType();
            if (mt.is(MediaType.MULTIPART_FORM_DATA)) {
                this.addMultipart(mt, options, this.form);
            } else if (mt.is(MediaType.APPLICATION_X_WWW_FORM_URLENCODED)) {
                this.addURLEncoded(this.form);
            }
        }
        return this.form;
    }

    public Map<String, Value> map() throws IOException {
        if (this.values == null) {
            this.values = new HashMap<String, Value>();
            this.stringMap().forEach((key, value) -> {
                ItemList items = new ItemList();
                for (String string : value) {
                    items.add((Object)new Atm(string));
                }
                this.values.put((String)key, items.value());
            });
        }
        return this.values;
    }

    public IOContent body() throws IOException {
        if (this.content == null) {
            this.content = new IOContent(new BufferInput((InputStream)this.conn.req.getInputStream()).content());
        }
        return this.content;
    }

    private void addMultipart(MediaType type, MainOptions options, Map<String, Value> map) throws QueryException, IOException {
        try (ArrayInput is = this.body().inputStream();){
            HttpPayload hp = new HttpPayload((InputStream)is, true, null, options);
            hp.multiForm(type).forEach(map::put);
        }
    }

    private void addURLEncoded(Map<String, Value> map) throws IOException {
        for (String param : Strings.split((String)this.body().toString(), (char)'&')) {
            String[] parts = Strings.split((String)param, (char)'=', (int)2);
            if (parts.length != 2) continue;
            Atm atm = new Atm(URLDecoder.decode(parts[1], "UTF-8"));
            map.merge(parts[0], (Value)atm, (value1, value2) -> {
                ItemList items = new ItemList();
                for (Item item : value1) {
                    items.add((Object)item);
                }
                for (Item item : value2) {
                    items.add((Object)item);
                }
                return items.value();
            });
        }
    }
}

