/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import javax.servlet.http.HttpSession;
import org.basex.http.BaseXServlet;
import org.basex.http.HTTPCode;
import org.basex.http.HTTPConnection;
import org.basex.http.restxq.RestXqFunction;
import org.basex.http.restxq.RestXqModules;
import org.basex.query.QueryException;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Str;
import org.basex.util.Token;

public final class RestXqServlet
extends BaseXServlet {
    @Override
    protected void run(HTTPConnection conn) throws Exception {
        if (conn.req.getPathInfo() == null) {
            conn.redirect("/");
            return;
        }
        RestXqModules rxm = RestXqModules.get(conn.context);
        if (conn.path().equals("/.init")) {
            rxm.init();
            return;
        }
        RestXqFunction func = rxm.find(conn, null);
        if (func == null) {
            throw HTTPCode.NO_XQUERY.get(new Object[0]);
        }
        try {
            boolean valid = true;
            for (RestXqFunction check : rxm.checks(conn)) {
                if (check.process(conn, func)) continue;
                valid = false;
                break;
            }
            if (valid) {
                func.process(conn, null);
            }
        }
        catch (QueryException ex) {
            func = rxm.find(conn, ex.qname());
            if (func == null) {
                throw ex;
            }
            func.process(conn, (Object)ex);
        }
    }

    @Override
    public String username(HTTPConnection http) {
        HttpSession session = http.req.getSession(false);
        byte[] value = null;
        if (session != null) {
            value = RestXqServlet.token(session.getAttribute("id"));
            if ((String.valueOf(http.path()) + '/').contains("/dba/")) {
                value = RestXqServlet.token(session.getAttribute("dba"));
            }
        }
        return value != null ? Token.string((byte[])Token.normalize(value)) : super.username(http);
    }

    private static byte[] token(Object value) {
        if (value instanceof Str) {
            return ((Str)value).string();
        }
        if (value instanceof Atm) {
            return ((Atm)value).string(null);
        }
        return null;
    }
}

