/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.value.item.QNm;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;

final class RestXqPathMatcher {
    private static final RestXqPathMatcher EMPTY = new RestXqPathMatcher("/", Collections.emptyList(), 0, BigInteger.ZERO);
    final List<QNm> varNames;
    final Pattern pattern;
    final int segments;
    final BigInteger varsPos;

    private RestXqPathMatcher(String regex, List<QNm> varNames, int segments, BigInteger varsPos) {
        this.varNames = varNames;
        this.segments = segments;
        this.varsPos = varsPos;
        this.pattern = Pattern.compile(regex);
    }

    boolean matches(String path) {
        return this.matcher(path).matches();
    }

    Map<QNm, String> values(String path) {
        HashMap<QNm, String> result = new HashMap<QNm, String>();
        Matcher m = this.matcher(path);
        if (m.matches()) {
            int groupCount = m.groupCount();
            if (this.varNames.size() <= groupCount) {
                int group = 1;
                for (QNm var : this.varNames) {
                    result.put(var, m.group(group));
                    int end = m.end(group);
                    while (++group <= groupCount && m.start(group) < end) {
                    }
                }
            }
        }
        return result;
    }

    private Matcher matcher(String input) {
        return this.pattern.matcher(input);
    }

    static RestXqPathMatcher parse(String path, InputInfo info) throws QueryException {
        if (path.isEmpty()) {
            return EMPTY;
        }
        ArrayList<QNm> varNames = new ArrayList<QNm>();
        StringBuilder result = new StringBuilder();
        StringBuilder literals = new StringBuilder();
        TokenBuilder variable = new TokenBuilder();
        StringBuilder regex = new StringBuilder();
        BitSet varsPos = new BitSet();
        int segment = 0;
        CharIterator i = new CharIterator(path);
        if (path.charAt(0) == '/') {
            i.next();
        }
        literals.append('/');
        while (i.hasNext()) {
            char ch = i.next();
            if (ch == '{') {
                byte[] var;
                RestXqPathMatcher.decodeAndEscape(literals, result, info);
                if (!i.hasNext() || i.nextNonWS() != '$') {
                    throw RestXqPathMatcher.error(info, "Invalid path template: \"%\".", path);
                }
                regex.append("[^/]+?");
                int braces = 1;
                while (i.hasNext()) {
                    ch = i.nextNonWS();
                    if (ch == '=') {
                        regex.setLength(0);
                        RestXqPathMatcher.addRegex(i, regex);
                        if (regex.length() != 0) break;
                        throw RestXqPathMatcher.error(info, "Invalid path template: \"%\".", path);
                    }
                    if (ch == '{') {
                        ++braces;
                        variable.add((int)ch);
                        continue;
                    }
                    if (ch == '}' && --braces == 0) break;
                    variable.add((int)ch);
                }
                if (!XMLToken.isQName((byte[])(var = variable.toArray()))) {
                    throw RestXqPathMatcher.error(info, "Invalid variable name: $%.", variable);
                }
                varNames.add(new QNm(var));
                variable.reset();
                varsPos.set(segment);
                result.append('(').append((CharSequence)regex).append(')');
                regex.setLength(0);
                continue;
            }
            if (ch == '/') {
                ++segment;
            }
            literals.append(ch);
        }
        RestXqPathMatcher.decodeAndEscape(literals, result, info);
        BigInteger vp = varsPos.cardinality() == 0 ? BigInteger.ZERO : new BigInteger(varsPos.toByteArray());
        return new RestXqPathMatcher(result.toString(), varNames, segment + 1, vp);
    }

    private static void addRegex(CharIterator i, StringBuilder result) {
        int braces = 1;
        while (i.hasNext()) {
            char ch = i.nextNonWS();
            if (ch == '{') {
                ++braces;
            } else if (ch == '}' && --braces == 0) break;
            result.append(ch);
        }
    }

    private static void decodeAndEscape(StringBuilder literals, StringBuilder result, InputInfo info) throws QueryException {
        if (literals.length() > 0) {
            byte[] path = Token.decodeUri((byte[])Token.token((String)literals.toString()));
            if (path == null) {
                throw RestXqPathMatcher.error(info, "Invalid URL encoding: \"%\".", literals);
            }
            TokenBuilder tb = new TokenBuilder(path.length);
            byte[] byArray = path;
            int n = path.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                if (".^&!?-:<>()[]{}$=,*+|".indexOf(b) >= 0) {
                    tb.addByte((byte)92);
                }
                tb.addByte(b);
                ++n2;
            }
            result.append(tb.toString());
            literals.setLength(0);
        }
    }

    private static QueryException error(InputInfo info, String msg, Object ... e) {
        return QueryError.BASEX_RESTXQ_X.get(info, new Object[]{Util.info((Object)msg, (Object[])e)});
    }

    private static final class CharIterator {
        private final String input;
        private final int len;
        private int pos;

        CharIterator(String input) {
            this.input = input;
            this.len = input.length();
        }

        boolean hasNext() {
            return this.pos < this.len;
        }

        char next() {
            return this.input.charAt(this.pos++);
        }

        char nextNonWS() {
            char ch;
            while (Character.isWhitespace(ch = this.next()) && this.hasNext()) {
            }
            return ch;
        }
    }
}

