/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import java.util.List;
import java.util.Map;
import org.basex.http.HTTPConnection;
import org.basex.http.restxq.RestXqPathMatcher;
import org.basex.query.QueryException;
import org.basex.query.value.item.QNm;
import org.basex.util.InputInfo;

final class RestXqPath
implements Comparable<RestXqPath> {
    private final String path;
    private final RestXqPathMatcher matcher;

    RestXqPath(String path, InputInfo info) throws QueryException {
        this.path = path;
        this.matcher = RestXqPathMatcher.parse(path, info);
    }

    boolean matches(HTTPConnection conn) {
        return this.matcher.matches(conn.path());
    }

    List<QNm> varNames() {
        return this.matcher.varNames;
    }

    Map<QNm, String> values(HTTPConnection conn) {
        return this.matcher.values(conn.path());
    }

    private boolean isTemplate(int s) {
        return this.matcher.varsPos.testBit(s);
    }

    @Override
    public int compareTo(RestXqPath rxs) {
        int ms = this.matcher.segments;
        int d = ms - rxs.matcher.segments;
        if (d != 0) {
            return d;
        }
        int s = 0;
        while (s < ms) {
            boolean wc2;
            boolean wc1 = this.isTemplate(s);
            if (wc1 != (wc2 = rxs.isTemplate(s))) {
                return wc1 ? 1 : -1;
            }
            ++s;
        }
        return 0;
    }

    public String toString() {
        return this.path;
    }
}

