/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import java.io.IOException;
import java.util.ArrayList;
import org.basex.core.Context;
import org.basex.http.HTTPCode;
import org.basex.http.HTTPConnection;
import org.basex.http.restxq.RestXqFunction;
import org.basex.http.restxq.RestXqResponse;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.func.StaticFunc;
import org.basex.util.Token;

final class RestXqModule {
    private final ArrayList<RestXqFunction> functions = new ArrayList();
    private final IOFile file;
    private long time;

    RestXqModule(IOFile file) {
        this.file = file;
        this.time = file.timeStamp();
    }

    boolean parse(Context ctx) throws Exception {
        this.functions.clear();
        Throwable throwable = null;
        Object var3_4 = null;
        try (QueryContext qc = this.qc(ctx);){
            String name = this.file.name();
            StaticFunc[] staticFuncArray = qc.funcs.funcs();
            int n = staticFuncArray.length;
            int n2 = 0;
            while (n2 < n) {
                RestXqFunction rxf;
                StaticFunc sf = staticFuncArray[n2];
                if (sf.expr != null && name.equals(new IOFile(sf.info.path()).name()) && (rxf = new RestXqFunction(sf, qc, this)).parse(ctx)) {
                    this.functions.add(rxf);
                }
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return !this.functions.isEmpty();
    }

    boolean uptodate() {
        return this.time == this.file.timeStamp();
    }

    void touch() {
        this.time = this.file.timeStamp();
    }

    ArrayList<RestXqFunction> functions() {
        return this.functions;
    }

    boolean process(HTTPConnection conn, RestXqFunction func, Object ext) throws Exception {
        Context ctx = conn.context;
        Throwable throwable = null;
        Object var6_7 = null;
        try (QueryContext qc = this.qc(ctx);){
            StaticFunc sf = RestXqModule.find(qc, func.function);
            if (sf == null) {
                throw HTTPCode.NO_XQUERY.get(new Object[0]);
            }
            RestXqFunction rxf = new RestXqFunction(sf, qc, this);
            rxf.parse(ctx);
            return new RestXqResponse(rxf, qc, conn).create(ext);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private QueryContext qc(Context ctx) throws Exception {
        QueryContext qc = new QueryContext(ctx);
        try {
            qc.parse(Token.string((byte[])this.file.read()), this.file.path(), null);
            return qc;
        }
        catch (IOException ex) {
            throw QueryError.IOERR_X.get(null, new Object[]{ex});
        }
    }

    private static StaticFunc find(QueryContext qc, StaticFunc func) {
        StaticFunc[] staticFuncArray = qc.funcs.funcs();
        int n = staticFuncArray.length;
        int n2 = 0;
        while (n2 < n) {
            StaticFunc sf = staticFuncArray[n2];
            if (func.info.equals((Object)sf.info)) {
                return sf;
            }
            ++n2;
        }
        return null;
    }
}

