/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.basex.BaseXServer;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.io.IOFile;
import org.basex.util.Prop;
import org.basex.util.Util;
import org.basex.util.options.Option;

public final class HTTPContext {
    private static volatile Context context;
    private static IOException exception;
    private static boolean init;
    private static BaseXServer server;

    private HTTPContext() {
    }

    public static Context context() {
        if (context == null) {
            context = new Context(true);
        }
        return context;
    }

    public static synchronized void init(ServletContext sc) throws IOException {
        if (init) {
            return;
        }
        init = true;
        String webapp = sc.getRealPath("/");
        System.setProperty("org.basex.path", webapp);
        Prop.put((Option)StaticOptions.WEBPATH, (String)webapp);
        Enumeration en = sc.getInitParameterNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String val = sc.getInitParameter(key);
            if (key.startsWith("org.basex.") && key.endsWith("path") && !new File(val).isAbsolute()) {
                Util.debug((Object)(String.valueOf(key.toUpperCase(Locale.ENGLISH)) + ": " + val), (Object[])new Object[0]);
                val = new IOFile(webapp, val).path();
            }
            Prop.put((String)key, (String)val);
        }
        if (context == null) {
            context = new Context(false);
        } else {
            HTTPContext.context.soptions.setSystem();
            HTTPContext.context.options.setSystem();
        }
        if (!HTTPContext.context.soptions.get(StaticOptions.HTTPLOCAL).booleanValue()) {
            try {
                server = new BaseXServer(context, new String[]{"-D"});
            }
            catch (IOException ex) {
                exception = ex;
                throw ex;
            }
        }
    }

    public static IOException exception() {
        return exception;
    }

    public static synchronized void close() {
        if (server != null) {
            server.stop();
            server = null;
        }
        if (context != null) {
            context.close();
            context = null;
        }
    }
}

