/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.basex.core.Context;
import org.basex.core.StaticOptions;
import org.basex.core.jobs.JobException;
import org.basex.core.users.Algorithm;
import org.basex.core.users.Code;
import org.basex.core.users.User;
import org.basex.http.BaseXServlet;
import org.basex.http.HTTPContext;
import org.basex.http.HTTPParams;
import org.basex.io.serial.SerialMethod;
import org.basex.io.serial.SerializerOptions;
import org.basex.server.ClientInfo;
import org.basex.server.Log;
import org.basex.server.LoginException;
import org.basex.util.Base64;
import org.basex.util.Performance;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.http.HttpClient;
import org.basex.util.http.HttpMethod;
import org.basex.util.http.HttpText;
import org.basex.util.http.MediaType;

public final class HTTPConnection
implements ClientInfo {
    public final HttpServletRequest req;
    public final HttpServletResponse res;
    public final BaseXServlet servlet;
    public final Context context;
    public final String method;
    public final HTTPParams params;
    private final Performance perf = new Performance();
    private final StaticOptions.AuthMethod auth;
    private final String path;
    private SerializerOptions serializer;
    private String username;

    HTTPConnection(HttpServletRequest req, HttpServletResponse res, BaseXServlet servlet) {
        this.req = req;
        this.res = res;
        this.servlet = servlet;
        this.context = new Context(HTTPContext.context(), (ClientInfo)this);
        this.method = req.getMethod();
        this.params = new HTTPParams(this);
        res.setCharacterEncoding("UTF-8");
        this.path = HTTPConnection.normalize(req.getPathInfo());
        this.auth = servlet.auth != null ? servlet.auth : (StaticOptions.AuthMethod)this.context.soptions.get(StaticOptions.AUTHMETHOD);
    }

    public void authenticate() throws IOException {
        User user;
        String name;
        String string = name = this.method.equals(HttpMethod.OPTIONS.name()) ? "admin" : this.servlet.user;
        if (name == null) {
            name = this.context.soptions.get(StaticOptions.USER);
        }
        if ((user = this.context.users.get(name)) == null) {
            user = this.login();
        }
        this.context.user(user);
        this.username = this.servlet.username(this);
        StringBuilder uri = new StringBuilder(this.req.getRequestURL());
        String qs = this.req.getQueryString();
        if (qs != null) {
            uri.append('?').append(qs);
        }
        this.context.log.write(Log.LogType.REQUEST, String.valueOf('[') + this.method + "] " + uri, null, this.context);
    }

    public MediaType contentType() {
        String ct = this.req.getContentType();
        return new MediaType(ct == null ? "" : ct);
    }

    public void initResponse() {
        SerializerOptions opts = this.sopts();
        String enc = opts.get(SerializerOptions.ENCODING);
        this.res.setCharacterEncoding(enc);
        this.res.setContentType(new MediaType(HTTPConnection.mediaType(opts) + "; " + "charset" + '=' + enc).toString());
    }

    public String path() {
        return this.path;
    }

    public String dbpath() {
        int i = this.path.indexOf(47, 1);
        return i == -1 ? "" : this.path.substring(i + 1);
    }

    public String db() {
        int i = this.path.indexOf(47, 1);
        return this.path.substring(1, i == -1 ? this.path.length() : i);
    }

    public MediaType[] accepts() {
        String accepts = this.req.getHeader("Accept");
        ArrayList<MediaType> list = new ArrayList<MediaType>();
        if (accepts == null) {
            list.add(MediaType.ALL_ALL);
        } else {
            String[] stringArray = accepts.split("\\s*,\\s*");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                double d;
                String accept = stringArray[n2];
                MediaType type = new MediaType(accept);
                String qf = (String)type.parameters().get("q");
                double d2 = d = qf != null ? Token.toDouble((byte[])Token.token((String)qf)) : 1.0;
                if (d > 0.0 && d <= 1.0) {
                    StringBuilder sb = new StringBuilder();
                    String main = type.main();
                    String sub = type.sub();
                    sb.append(main.isEmpty() ? "*" : main).append('/');
                    sb.append(sub.isEmpty() ? "*" : sub).append("; q=").append(d);
                    list.add(new MediaType(sb.toString()));
                }
                ++n2;
            }
        }
        return list.toArray(new MediaType[list.size()]);
    }

    public void error(int code, String info) throws IOException {
        this.status(code, null, info);
    }

    public void status(int code, String message) throws IOException {
        this.status(code, message, null);
    }

    public void sopts(SerializerOptions opts) {
        this.serializer = opts;
    }

    public SerializerOptions sopts() {
        if (this.serializer == null) {
            this.serializer = new SerializerOptions();
        }
        return this.serializer;
    }

    void log(int status, String info) {
        this.context.log.write(Integer.toString(status), info, this.perf, this.context);
    }

    public String resolve(String location) {
        String loc = location;
        if (location.startsWith("/")) {
            String uri = this.req.getRequestURI();
            String info = this.req.getPathInfo();
            loc = String.valueOf(info == null ? uri : uri.substring(0, uri.length() - info.length())) + location;
        }
        return loc;
    }

    public void redirect(String location) throws IOException {
        this.res.sendRedirect(this.resolve(location));
    }

    public void forward(String location) throws IOException, ServletException {
        this.req.getRequestDispatcher(this.resolve(location)).forward((ServletRequest)this.req, (ServletResponse)this.res);
    }

    public String clientAddress() {
        return String.valueOf(this.req.getRemoteAddr()) + ':' + this.req.getRemotePort();
    }

    public String clientName() {
        return this.username;
    }

    public static MediaType mediaType(SerializerOptions sopts) {
        String type = sopts.get(SerializerOptions.MEDIA_TYPE);
        if (!type.isEmpty()) {
            return new MediaType(type);
        }
        SerialMethod sm = (SerialMethod)sopts.get(SerializerOptions.METHOD);
        if (sm == SerialMethod.BASEX || sm == SerialMethod.ADAPTIVE || sm == SerialMethod.XML) {
            return MediaType.APPLICATION_XML;
        }
        if (sm == SerialMethod.XHTML || sm == SerialMethod.HTML) {
            return MediaType.TEXT_HTML;
        }
        if (sm == SerialMethod.JSON) {
            return MediaType.APPLICATION_JSON;
        }
        return MediaType.TEXT_PLAIN;
    }

    private static String normalize(String path) {
        TokenBuilder tmp = new TokenBuilder();
        if (path != null) {
            TokenBuilder tb = new TokenBuilder();
            int pl = path.length();
            int p = 0;
            while (p < pl) {
                char ch = path.charAt(p);
                if (ch == '/') {
                    if (!tb.isEmpty()) {
                        tmp.add(47).add(tb.toArray());
                        tb.reset();
                    }
                } else {
                    tb.add((int)ch);
                }
                ++p;
            }
            if (!tb.isEmpty()) {
                tmp.add(47).add(tb.finish());
            }
        }
        if (tmp.isEmpty()) {
            tmp.add(47);
        }
        return tmp.toString();
    }

    private User login() throws IOException {
        byte[] address = Token.token((String)this.req.getRemoteAddr());
        try {
            User user;
            if (this.auth == StaticOptions.AuthMethod.CUSTOM) {
                user = this.user("admin");
            } else {
                String[] stringArray;
                String header = this.req.getHeader("Authorization");
                if (header != null) {
                    stringArray = Strings.split((String)header, (char)' ', (int)2);
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "";
                }
                String[] am = stringArray;
                StaticOptions.AuthMethod meth = (StaticOptions.AuthMethod)StaticOptions.AUTHMETHOD.get(am[0]);
                if (this.auth != meth) {
                    throw new LoginException("% authentication expected.", new Object[]{this.auth});
                }
                if (this.auth == StaticOptions.AuthMethod.BASIC) {
                    String details = am.length > 1 ? am[1] : "";
                    String[] creds = Strings.split((String)Base64.decode((String)details), (char)':', (int)2);
                    user = this.user(creds[0]);
                    if (creds.length < 2 || !user.matches(creds[1])) {
                        throw new LoginException();
                    }
                } else {
                    EnumMap map = HttpClient.digestHeaders((String)header);
                    user = this.user((String)map.get(HttpText.Request.USERNAME));
                    String nonce = (String)map.get(HttpText.Request.NONCE);
                    String cnonce = (String)map.get(HttpText.Request.CNONCE);
                    String ha1 = user.code(Algorithm.DIGEST, Code.HASH);
                    if (Strings.eq((String)((String)map.get(HttpText.Request.ALGORITHM)), (String)"MD5-sess")) {
                        ha1 = Strings.md5((String)(String.valueOf(ha1) + ':' + nonce + ':' + cnonce));
                    }
                    String h2 = String.valueOf(this.method) + ':' + (String)map.get(HttpText.Request.URI);
                    String qop = (String)map.get(HttpText.Request.QOP);
                    if (Strings.eq((String)qop, (String)"auth-int")) {
                        h2 = String.valueOf(h2) + ':' + Strings.md5((String)this.params.body().toString());
                    }
                    String ha2 = Strings.md5((String)h2);
                    StringBuilder response = new StringBuilder(ha1).append(':').append(nonce);
                    if (Strings.eq((String)qop, (String[])new String[]{"auth", "auth-int"})) {
                        response.append(':').append((String)map.get(HttpText.Request.NC));
                        response.append(':').append(cnonce).append(':').append(qop);
                    }
                    response.append(':').append(ha2);
                    if (!Strings.md5((String)response.toString()).equals(map.get(HttpText.Request.RESPONSE))) {
                        throw new LoginException();
                    }
                }
            }
            this.context.blocker.remove(address);
            return user;
        }
        catch (LoginException ex) {
            this.context.blocker.delay(address);
            throw ex;
        }
    }

    private User user(String user) throws LoginException {
        User u = this.context.users.get(user);
        if (u == null) {
            throw new LoginException();
        }
        return u;
    }

    public void stop(JobException ex) throws IOException {
        int code = 460;
        String info = ex.getMessage();
        this.log(460, info);
        try {
            this.res.resetBuffer();
            this.res.setStatus(460);
            this.res.setContentType(MediaType.TEXT_PLAIN.toString());
            this.res.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            this.res.setHeader("Pragma", "no-cache");
            this.res.setHeader("Expires", "0");
            this.res.getOutputStream().write(Token.token((String)info));
        }
        catch (IllegalStateException e) {
            this.logError(460, null, info, e);
        }
    }

    private void status(int code, String message, String info) throws IOException {
        this.log(code, message != null ? message : (info != null ? info : ""));
        try {
            int c;
            this.res.resetBuffer();
            if (code == 401) {
                TokenBuilder header = new TokenBuilder(this.auth.toString());
                header.add(32).addExt((Object)HttpText.Request.REALM, new Object[0]).add("=\"").add("BaseX").add(34);
                if (this.auth == StaticOptions.AuthMethod.DIGEST) {
                    String nonce = Strings.md5((String)Long.toString(System.nanoTime()));
                    header.add(",").addExt((Object)HttpText.Request.QOP, new Object[0]).add("=\"").add("auth").add(44).add("auth-int").add(34);
                    header.add(44).addExt((Object)HttpText.Request.NONCE, new Object[0]).add("=\"").add(nonce).add(34);
                }
                this.res.setHeader("WWW-Authenticate", header.toString());
            }
            int n = c = code < 0 || code > 999 ? 500 : code;
            if (message == null) {
                this.res.setStatus(c);
            } else {
                this.res.setStatus(c, message);
            }
            if (info != null) {
                this.res.setContentType(MediaType.TEXT_PLAIN.toString());
                this.res.getOutputStream().write(new TokenBuilder(Token.token((String)info)).normalize().finish());
            }
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            this.logError(code, message, info, ex);
        }
    }

    private void logError(int code, String message, String info, Exception ex) {
        StringBuilder sb = new StringBuilder();
        sb.append("Code: ").append(code);
        if (info != null) {
            sb.append(", Info: ").append(info);
        }
        if (message != null) {
            sb.append(", Message: ").append(message);
        }
        sb.append(", Error: ").append(Util.message((Throwable)ex));
        this.log(500, sb.toString());
    }
}

