/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.webdav;

import com.bradmcevoy.http.webdav.PropertySourceUtil;
import com.bradmcevoy.http.webdav.ResourceTypeHelper;
import com.bradmcevoy.property.PropertySource;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertySourcesList
extends ArrayList<PropertySource> {
    private static final Logger log = LoggerFactory.getLogger(PropertySourcesList.class);
    private static final long serialVersionUID = 1L;

    public PropertySourcesList() {
        log.info("Created PropertySourcesList");
    }

    public PropertySourcesList(ResourceTypeHelper resourceTypeHelper) {
        this.addAll(PropertySourceUtil.createDefaultSources(resourceTypeHelper));
        log.info("Created propertysourceslist, hashcode: " + this.hashCode() + " size: " + this.size());
    }

    @Override
    public boolean add(PropertySource e) {
        log.info("adding property source: " + e.getClass() + " to PropertySourcesList: " + this.hashCode());
        return super.add(e);
    }

    public void setExtraSource(PropertySource source) {
        this.add(source);
    }

    public void setSources(List<PropertySource> sources) {
        this.clear();
        this.addAll(sources);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (PropertySource l : this) {
            sb.append(l.getClass()).append(",");
        }
        return sb.toString();
    }
}

