/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.options;

import org.basex.util.list.StringList;
import org.basex.util.options.Option;

public final class EnumOption<V extends Enum<V>>
extends Option<V> {
    private final Class<V> clazz;
    private final V value;

    public EnumOption(String name, V value) {
        super(name);
        this.value = value;
        this.clazz = value.getClass();
    }

    public EnumOption(String name, Class<V> clazz) {
        super(name);
        this.clazz = clazz;
        this.value = null;
    }

    @Override
    public V value() {
        return this.value;
    }

    public V get(String string) {
        Enum[] enumArray = this.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum v = enumArray[n2];
            if (v.toString().equals(string)) {
                return (V)v;
            }
            ++n2;
        }
        return null;
    }

    public V[] values() {
        return (Enum[])this.clazz.getEnumConstants();
    }

    public String[] strings() {
        Enum[] values = this.values();
        StringList sl = new StringList(values.length);
        Enum[] enumArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Enum v = enumArray[n2];
            sl.add(v.toString());
            ++n2;
        }
        return (String[])sl.finish();
    }
}

