/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import org.basex.io.in.NewlineInput;
import org.basex.util.Strings;
import org.basex.util.Util;

public final class MediaType {
    private static final String MULTIPART = "multipart";
    private static final String TEXT = "text";
    private static final String XQUERY = "xquery";
    private static final String CSV = "csv";
    private static final String COMMA_SEPARATED_VALUES = "comma-separated-values";
    private static final String XML_SUFFIX = "+xml";
    public static final MediaType ALL_ALL;
    public static final MediaType APPLICATION_X_WWW_FORM_URLENCODED;
    public static final MediaType APPLICATION_HTML_XML;
    public static final MediaType APPLICATION_JSON;
    public static final MediaType APPLICATION_OCTET_STREAM;
    public static final MediaType APPLICATION_XML;
    public static final MediaType APPLICATION_XML_EPE;
    public static final MediaType MULTIPART_FORM_DATA;
    public static final MediaType TEXT_CSV;
    public static final MediaType TEXT_HTML;
    public static final MediaType TEXT_PLAIN;
    public static final MediaType TEXT_XML;
    public static final MediaType TEXT_XML_EPE;
    private final String main;
    private final String sub;
    private final HashMap<String, String> params = new HashMap();
    private static final HashMap<String, MediaType> TYPES;

    static {
        block14: {
            ALL_ALL = new MediaType("*/*");
            APPLICATION_X_WWW_FORM_URLENCODED = new MediaType("application/x-www-form-urlencoded");
            APPLICATION_HTML_XML = new MediaType("application/html+xml");
            APPLICATION_JSON = new MediaType("application/json");
            APPLICATION_OCTET_STREAM = new MediaType("application/octet-stream");
            APPLICATION_XML = new MediaType("application/xml");
            APPLICATION_XML_EPE = new MediaType("application/xml-external-parsed-entity");
            MULTIPART_FORM_DATA = new MediaType("multipart/form-data");
            TEXT_CSV = new MediaType("text/csv");
            TEXT_HTML = new MediaType("text/html");
            TEXT_PLAIN = new MediaType("text/plain");
            TEXT_XML = new MediaType("text/xml");
            TEXT_XML_EPE = new MediaType("text/xml-external-parsed-entity");
            TYPES = new HashMap();
            HashMap<String, MediaType> cache = new HashMap<String, MediaType>();
            try {
                String file = "/media-types.properties";
                InputStream is = MediaType.class.getResourceAsStream("/media-types.properties");
                if (is == null) {
                    Util.errln("/media-types.properties not found.", new Object[0]);
                    break block14;
                }
                Throwable throwable = null;
                Object var4_7 = null;
                try (NewlineInput nli = new NewlineInput(is);){
                    String line;
                    while ((line = nli.readLine()) != null) {
                        int i = line.indexOf(61);
                        if (i == -1 || line.startsWith("#")) continue;
                        String suffix = line.substring(0, i);
                        String type = line.substring(i + 1);
                        MediaType mt = cache.computeIfAbsent(type, MediaType::new);
                        TYPES.put(suffix, mt);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                Util.errln(ex, new Object[0]);
            }
            catch (Throwable ex) {
                Util.stack(ex);
            }
        }
    }

    public MediaType(String string) {
        int p = string.indexOf(59);
        String type = p == -1 ? string : string.substring(0, p);
        int s = type.indexOf(47);
        this.main = s == -1 ? type : type.substring(0, s);
        String string2 = this.sub = s == -1 ? "" : type.substring(s + 1);
        if (p != -1) {
            String[] stringArray = Strings.split(string.substring(p + 1), ';');
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                String[] kv = Strings.split(param, '=', 2);
                this.params.put(kv[0].trim(), kv.length < 2 ? "" : kv[1].trim());
                ++n2;
            }
        }
    }

    public String main() {
        return this.main;
    }

    public String sub() {
        return this.sub;
    }

    public String type() {
        return this.sub.isEmpty() ? this.main : String.valueOf(this.main) + '/' + this.sub;
    }

    public HashMap<String, String> parameters() {
        return this.params;
    }

    public boolean isMultipart() {
        return this.main.equals(MULTIPART);
    }

    public boolean isText() {
        return this.main.equals(TEXT);
    }

    public boolean isXQuery() {
        return this.sub.equals(XQUERY);
    }

    public boolean isCSV() {
        return this.sub.equals(CSV) || this.sub.equals(COMMA_SEPARATED_VALUES);
    }

    public boolean isXML() {
        return this.is(TEXT_XML) || this.is(TEXT_XML_EPE) || this.is(APPLICATION_XML) || this.is(APPLICATION_XML_EPE) || this.sub.endsWith(XML_SUFFIX);
    }

    public boolean matches(MediaType pattern) {
        return Strings.eq(pattern.main(), this.main, "*") && Strings.eq(pattern.sub(), this.sub, "*");
    }

    public boolean is(MediaType type) {
        return this.main.equals(type.main) && this.sub.equals(type.sub);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.type());
        this.params.forEach((key, value) -> {
            StringBuilder stringBuilder2 = sb.append("; ").append((String)key).append('=').append((String)value);
        });
        return sb.toString();
    }

    public static MediaType get(String path) {
        int s = path.lastIndexOf(47);
        int d = path.lastIndexOf(46);
        String suffix = d <= s ? "" : path.substring(d + 1).toLowerCase(Locale.ENGLISH);
        return TYPES.getOrDefault(suffix, APPLICATION_OCTET_STREAM);
    }
}

