/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.basex.core.StaticOptions;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.http.HttpRequest;
import org.basex.util.http.HttpText;

public final class HttpRequestParser {
    private final InputInfo info;

    public HttpRequestParser(InputInfo info) {
        this.info = info;
    }

    public HttpRequest parse(ANode request, Value bodies) throws QueryException {
        HttpRequest hr = new HttpRequest();
        if (request != null) {
            for (ANode attr : request.attributes()) {
                String key = Token.string(attr.name());
                HttpText.Request r = HttpText.Request.get(key);
                if (r == null) {
                    throw QueryError.HC_REQ_X.get(this.info, "Unknown attribute: " + key);
                }
                hr.attributes.put(r, Token.string(attr.string()));
            }
            this.checkRequest(hr);
            ANode body = HttpRequestParser.parseHeaders(request.children(), hr.headers);
            String method = hr.attribute(HttpText.Request.METHOD);
            if (Strings.eq(method, "TRACE", "DELETE") && (body != null || !bodies.isEmpty())) {
                throw QueryError.HC_REQ_X.get(this.info, "Body not expected for method " + method);
            }
            if (body != null) {
                QNm pl = body.qname();
                if (pl.eq(HttpText.Q_BODY)) {
                    this.parseBody(body, bodies, hr.payloadAtts, hr.payload);
                    hr.isMultipart = false;
                } else if (pl.eq(HttpText.Q_MULTIPART)) {
                    this.parseMultipart(body, bodies.iter(), hr.payloadAtts, hr.parts);
                    hr.isMultipart = true;
                } else {
                    throw QueryError.HC_REQ_X.get(this.info, "Unknown payload element: " + body.qname());
                }
            }
        }
        return hr;
    }

    private static void parseAtts(ANode element, Map<String, String> atts) {
        for (ANode attr : element.attributes()) {
            atts.put(Token.string(attr.name()), Token.string(attr.string()));
        }
    }

    private static ANode parseHeaders(BasicNodeIter iter, Map<String, String> headers) {
        for (ANode node : iter) {
            QNm nm = node.qname();
            if (nm == null) continue;
            if (!nm.eq(HttpText.Q_HEADER)) {
                return node;
            }
            String name = "";
            String value = "";
            for (ANode attr : node.attributes()) {
                String qn = Token.string(attr.qname().local());
                if (qn.equals("name")) {
                    name = Token.string(attr.string());
                    continue;
                }
                if (!qn.equals("value")) continue;
                value = Token.string(attr.string());
            }
            if (name.isEmpty() || value.isEmpty()) continue;
            headers.put(name, value);
        }
        return null;
    }

    private void parseBody(ANode body, Value items, Map<String, String> atts, ItemList payload) throws QueryException {
        block4: {
            HttpRequestParser.parseAtts(body, atts);
            this.checkBody(body, atts);
            if (atts.get("src") != null) break block4;
            if (items.isEmpty()) {
                for (ANode n : body.children()) {
                    payload.add(n);
                }
            } else {
                for (Item item : items) {
                    payload.add(item);
                }
            }
        }
    }

    private void parseMultipart(ANode multipart, BasicIter<Item> bodies, HashMap<String, String> atts, ArrayList<HttpRequest.Part> parts) throws QueryException {
        HttpRequestParser.parseAtts(multipart, atts);
        if (atts.get(SerializerOptions.MEDIA_TYPE.name()) == null) {
            throw QueryError.HC_REQ_X.get(this.info, "Attribute media-type of http:multipart is mandatory");
        }
        BasicNodeIter iter = multipart.children();
        while (true) {
            HttpRequest.Part part = new HttpRequest.Part();
            ANode payload = HttpRequestParser.parseHeaders(iter, part.headers);
            if (payload == null) break;
            Item body = bodies.next();
            this.parseBody(payload, body == null ? Empty.SEQ : body, part.bodyAtts, part.bodyContents);
            parts.add(part);
        }
    }

    private void checkRequest(HttpRequest req) throws QueryException {
        String timeout;
        String mth = req.attribute(HttpText.Request.METHOD);
        if (mth == null) {
            throw QueryError.HC_REQ_X.get(this.info, "Missing attribute: " + (Object)((Object)HttpText.Request.METHOD));
        }
        req.attributes.put(HttpText.Request.METHOD, mth.toUpperCase(Locale.ENGLISH));
        String sendAuth = req.attribute(HttpText.Request.SEND_AUTHORIZATION);
        if (sendAuth != null && Strings.yes(sendAuth)) {
            String us = req.attribute(HttpText.Request.USERNAME);
            if (us == null) {
                throw QueryError.HC_REQ_X.get(this.info, "Missing attribute: " + (Object)((Object)HttpText.Request.USERNAME));
            }
            String pw = req.attribute(HttpText.Request.PASSWORD);
            if (pw == null) {
                throw QueryError.HC_REQ_X.get(this.info, "Missing attribute: " + (Object)((Object)HttpText.Request.PASSWORD));
            }
            String am = req.attribute(HttpText.Request.AUTH_METHOD);
            if (am != null && !am.isEmpty()) {
                req.authMethod = StaticOptions.AUTHMETHOD.get(am);
                if (req.authMethod == null) {
                    throw QueryError.HC_REQ_X.get(this.info, "Invalid authentication method: " + am);
                }
            }
        } else {
            req.attributes.remove((Object)HttpText.Request.USERNAME);
            req.attributes.remove((Object)HttpText.Request.PASSWORD);
            req.attributes.remove((Object)HttpText.Request.AUTH_METHOD);
        }
        if ((timeout = req.attribute(HttpText.Request.TIMEOUT)) != null && Strings.toInt(timeout) < 0) {
            throw QueryError.HC_REQ_X.get(this.info, "Invalid timeout: " + timeout);
        }
        HttpText.Request[] requestArray = new HttpText.Request[]{HttpText.Request.FOLLOW_REDIRECT, HttpText.Request.STATUS_ONLY, HttpText.Request.SEND_AUTHORIZATION};
        int n = requestArray.length;
        int n2 = 0;
        while (n2 < n) {
            HttpText.Request r = requestArray[n2];
            String s = req.attribute(r);
            if (s != null && !Strings.eq(s, "true", "false")) {
                throw QueryError.HC_REQ_X.get(this.info, "Value of '" + (Object)((Object)r) + "' attribute is no boolean: " + s);
            }
            ++n2;
        }
    }

    private void checkBody(ANode body, Map<String, String> bodyAtts) throws QueryException {
        if (bodyAtts.get(SerializerOptions.MEDIA_TYPE.name()) == null) {
            throw QueryError.HC_REQ_X.get(this.info, "Attribute media-type of http:body is mandatory");
        }
        if (bodyAtts.get("src") != null && (bodyAtts.size() > 2 || body.children().next() != null)) {
            throw QueryError.HC_ATTR.get(this.info, new Object[0]);
        }
    }
}

