/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.HashMap;
import java.util.Locale;
import org.basex.core.MainOptions;

public final class Language
implements Comparable<Language> {
    static final HashMap<String, Language> ALL = new HashMap();
    private static final HashMap<String, Language> DISP = new HashMap();
    private final Locale locale;

    static {
        Locale[] localeArray = Locale.getAvailableLocales();
        int n = localeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Locale l = localeArray[n2];
            ALL.put(l.getLanguage(), new Language(l));
            DISP.put(l.getDisplayLanguage(Locale.ENGLISH), new Language(l));
            ++n2;
        }
    }

    private Language(Locale locale) {
        this.locale = locale;
    }

    public static Language get(String lang) {
        int i = lang.indexOf(45);
        String l = i == -1 ? lang : lang.substring(0, i);
        Language ln = ALL.get(l.toLowerCase(Locale.ENGLISH));
        return ln == null ? DISP.get(lang) : ln;
    }

    public static Language get(MainOptions opts) {
        Language ln = Language.get(opts.get(MainOptions.LANGUAGE));
        return ln == null ? Language.get("en") : ln;
    }

    public static Language def() {
        Language ln = DISP.get(MainOptions.LANGUAGE.value());
        return ln == null ? Language.get("en") : ln;
    }

    public String code() {
        return this.locale.getLanguage();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Language && this.code().equals(((Language)obj).code());
    }

    public int hashCode() {
        return this.code().hashCode();
    }

    @Override
    public int compareTo(Language o) {
        return this.code().compareTo(o.code());
    }

    public String toString() {
        return this.locale.getDisplayLanguage(Locale.ENGLISH);
    }
}

