/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import org.basex.util.Array;
import org.basex.util.Token;

public final class History {
    private static final int MAXBYTES = 10000000;
    private static final int MAX = 1024;
    private final byte[][] hist;
    private final int[] caret;
    private final boolean active;
    private int max;
    private int pos;
    private int saved;

    public History(byte[] text) {
        boolean bl = this.active = text != null;
        if (this.active) {
            this.caret = new int[1024];
            this.hist = new byte[1024][];
            this.init(text);
        } else {
            this.caret = null;
            this.hist = null;
        }
    }

    public void init(byte[] text) {
        this.hist[0] = text;
        this.pos = 0;
        this.max = 0;
    }

    public boolean active() {
        return this.active;
    }

    public boolean first() {
        return this.pos == 0;
    }

    public boolean last() {
        return this.pos == this.max;
    }

    public byte[] prev() {
        return this.pos > 0 ? this.hist[--this.pos] : null;
    }

    public byte[] next() {
        return this.pos < this.max ? this.hist[++this.pos] : null;
    }

    public int caret() {
        return this.caret[this.pos];
    }

    public void store(byte[] str, int oc, int nc) {
        if (!this.active || str == this.hist[this.pos] || Token.eq(str, this.hist[this.pos])) {
            return;
        }
        int len = str.length;
        if (this.pos > 0 && this.saved != this.pos && this.caret[this.pos] == oc && oc + 1 == nc && this.hist[this.pos - 1].length < len) {
            this.hist[this.pos] = str;
            this.caret[this.pos] = nc;
            return;
        }
        int off = this.pos + 1;
        while (off > 0 && len < 10000000) {
            len += this.hist[off - 1].length;
            --off;
        }
        if (off == 0 && this.pos + 1 == 1024) {
            off = 1;
        }
        if (off > 0) {
            Array.move(this.hist, off, -off, 1024 - off);
            Array.move(this.caret, off, -off, 1024 - off);
            this.saved -= off;
            this.pos -= off;
        }
        if (this.pos >= 0) {
            this.caret[this.pos] = oc;
        }
        if (this.saved > this.pos) {
            this.saved = -1;
        }
        this.max = ++this.pos;
        this.hist[this.pos] = str;
        this.caret[this.pos] = nc;
        int p = this.pos + 1;
        while (p < 1024) {
            this.hist[p] = null;
            ++p;
        }
    }

    public void save() {
        this.saved = this.pos;
    }

    public boolean modified() {
        return this.saved != this.pos;
    }
}

