/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.util.Arrays;
import org.basex.util.Num;

public final class Compress {
    public static final long COMPRESS = 0x4000000000L;
    private static final byte[] UNPACK1;
    private static final byte[] UNPACK2;
    private static final byte[] PACK1;
    private static final byte[] PACK2;

    static {
        byte[] byArray = new byte[128];
        byArray[0] = 32;
        byArray[1] = 97;
        byArray[2] = 101;
        byArray[3] = 110;
        byArray[4] = 105;
        byArray[5] = 111;
        byArray[6] = 114;
        byArray[7] = 115;
        byArray[8] = 116;
        byArray[9] = 108;
        byArray[10] = 117;
        byArray[11] = 104;
        byArray[12] = 100;
        byArray[13] = 99;
        byArray[14] = 103;
        byArray[15] = 109;
        byArray[16] = 112;
        byArray[17] = 121;
        byArray[18] = 98;
        byArray[19] = 107;
        byArray[20] = 102;
        byArray[21] = 118;
        byArray[22] = 67;
        byArray[23] = 83;
        byArray[24] = 119;
        byArray[25] = 77;
        byArray[26] = 65;
        byArray[27] = 66;
        byArray[28] = 80;
        byArray[29] = 122;
        byArray[30] = 46;
        byArray[31] = 10;
        byArray[32] = 84;
        byArray[33] = 82;
        byArray[34] = 75;
        byArray[35] = 76;
        byArray[36] = 71;
        byArray[37] = 78;
        byArray[38] = 72;
        byArray[39] = 106;
        byArray[40] = 69;
        byArray[41] = 73;
        byArray[42] = 68;
        byArray[43] = 70;
        byArray[44] = 74;
        byArray[45] = 120;
        byArray[46] = 79;
        byArray[47] = 113;
        byArray[48] = 48;
        byArray[49] = 49;
        byArray[50] = 50;
        byArray[51] = 51;
        byArray[52] = 52;
        byArray[53] = 53;
        byArray[54] = 54;
        byArray[55] = 55;
        byArray[56] = 56;
        byArray[57] = 57;
        byArray[58] = 58;
        byArray[59] = 45;
        byArray[60] = 39;
        byArray[61] = 44;
        byArray[62] = 34;
        byArray[63] = 63;
        byArray[64] = 86;
        byArray[65] = 87;
        byArray[66] = 85;
        byArray[67] = 90;
        byArray[68] = 89;
        byArray[69] = 81;
        byArray[70] = 88;
        byArray[71] = 9;
        byArray[72] = 64;
        byArray[73] = 40;
        byArray[74] = 47;
        byArray[75] = 41;
        byArray[76] = 43;
        byArray[77] = 126;
        byArray[78] = 33;
        byArray[79] = 35;
        byArray[80] = 36;
        byArray[81] = 37;
        byArray[82] = 38;
        byArray[83] = 42;
        byArray[84] = 59;
        byArray[85] = 60;
        byArray[86] = 61;
        byArray[87] = 62;
        byArray[88] = 91;
        byArray[89] = 92;
        byArray[90] = 93;
        byArray[91] = 94;
        byArray[92] = 95;
        byArray[93] = 96;
        byArray[94] = 123;
        byArray[95] = 124;
        byArray[96] = 125;
        byArray[97] = 127;
        byArray[99] = 1;
        byArray[100] = 2;
        byArray[101] = 3;
        byArray[102] = 4;
        byArray[103] = 5;
        byArray[104] = 6;
        byArray[105] = 7;
        byArray[106] = 8;
        byArray[107] = 11;
        byArray[108] = 12;
        byArray[109] = 13;
        byArray[110] = 14;
        byArray[111] = 15;
        byArray[112] = 16;
        byArray[113] = 17;
        byArray[114] = 18;
        byArray[115] = 19;
        byArray[116] = 20;
        byArray[117] = 21;
        byArray[118] = 22;
        byArray[119] = 23;
        byArray[120] = 24;
        byArray[121] = 25;
        byArray[122] = 26;
        byArray[123] = 27;
        byArray[124] = 28;
        byArray[125] = 29;
        byArray[126] = 30;
        byArray[127] = 31;
        UNPACK1 = byArray;
        UNPACK2 = new byte[UNPACK1.length];
        PACK1 = new byte[UNPACK1.length];
        PACK2 = new byte[UNPACK1.length];
        int pl = UNPACK1.length;
        int p = 0;
        while (p < pl) {
            byte b2;
            int b1 = UNPACK1[p];
            Compress.UNPACK2[p] = b2 = (byte)(b1 >= 65 && b1 <= 90 ? b1 + 32 : (b1 >= 97 && b1 <= 122 ? b1 - 32 : b1));
            Compress.PACK1[b1] = (byte)p;
            Compress.PACK2[b2] = (byte)p;
            ++p;
        }
    }

    private Compress() {
    }

    public static byte[] pack(byte[] text) {
        byte[] map;
        int length = text.length - 1;
        if (length < 4) {
            return text;
        }
        byte[] bytes = new byte[length];
        int size = Num.set(bytes, length + 1);
        int lc = 0;
        int uc = 0;
        int out = 0;
        byte[] byArray = text;
        int n = text.length;
        int n2 = 0;
        while (n2 < n) {
            byte t = byArray[n2];
            lc += t >= 65 && t <= 90 ? -1 : 1;
            uc += t >= 0 ? 1 : -1;
            ++n2;
        }
        if (uc < 0) {
            return text;
        }
        if (lc >= 0) {
            out = 2;
            map = PACK1;
        } else {
            map = PACK2;
        }
        int off = 2;
        byte[] byArray2 = text;
        int n3 = text.length;
        int n4 = 0;
        while (n4 < n3) {
            int s;
            int in;
            byte b;
            byte t = byArray2[n4];
            byte by = b = t >= 0 ? map[t] : t;
            if (b >= 0 && b < 8) {
                in = 1 | b << 1;
                s = 4;
            } else if (b >= 8 && b < 16) {
                in = 2 | b << 2;
                s = 5;
            } else if (b >= 16 && b < 32) {
                in = 4 | b << 3;
                s = 7;
            } else if (b >= 32 && b < 64) {
                in = 8 | b << 4;
                s = 9;
            } else {
                in = b << 4;
                s = 12;
            }
            int i = 0;
            while (i < s) {
                out |= (in & 1) << off;
                in >>>= 1;
                if ((off = off + 1 & 7) == 0) {
                    if (size == length) {
                        return text;
                    }
                    bytes[size++] = (byte)out;
                    out = 0;
                }
                ++i;
            }
            ++n4;
        }
        if (off != 0) {
            if (size == length) {
                return text;
            }
            bytes[size++] = (byte)out;
        }
        return size < length ? Arrays.copyOf(bytes, size) : bytes;
    }

    public static byte[] unpack(byte[] text) {
        int pos = (Num.length(text, 0) << 3) + 1;
        byte[] map = Compress.isSet(text, pos++) ? UNPACK1 : UNPACK2;
        int size = Num.get(text, 0);
        byte[] bytes = new byte[size];
        int b = 0;
        while (b < size) {
            int bits;
            int out = 0;
            if (Compress.isSet(text, pos++)) {
                bits = 3;
            } else if (Compress.isSet(text, pos++)) {
                bits = 3;
                out = 8;
            } else if (Compress.isSet(text, pos++)) {
                bits = 4;
                out = 16;
            } else if (Compress.isSet(text, pos++)) {
                bits = 5;
                out = 32;
            } else {
                bits = 8;
            }
            int bit = 0;
            while (bit < bits) {
                if ((text[pos >>> 3] & 1 << (pos & 7)) != 0) {
                    out |= 1 << bit;
                }
                ++bit;
                ++pos;
            }
            bytes[b] = (byte)(out >= 128 ? out : map[out]);
            ++b;
        }
        return bytes;
    }

    public static boolean compressed(long value) {
        return (value & 0x4000000000L) != 0L;
    }

    private static boolean isSet(byte[] txt, int pos) {
        return (txt[pos >>> 3] & 1 << (pos & 7)) != 0;
    }
}

