/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Timer;
import org.basex.BaseXServer;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Replace;
import org.basex.core.cmd.Store;
import org.basex.core.users.Algorithm;
import org.basex.core.users.Code;
import org.basex.core.users.User;
import org.basex.io.in.BufferInput;
import org.basex.io.in.ServerInput;
import org.basex.io.out.PrintOutput;
import org.basex.query.QueryTracer;
import org.basex.server.ClientInfo;
import org.basex.server.Log;
import org.basex.server.ServerCmd;
import org.basex.server.ServerQuery;
import org.basex.util.Performance;
import org.basex.util.Strings;
import org.basex.util.Util;

public final class ClientListener
extends Thread
implements ClientInfo {
    public final Timer timeout = new Timer();
    public long last;
    private final HashMap<String, ServerQuery> queries = new HashMap();
    private final Performance perf = new Performance();
    private final Context context;
    private final BaseXServer server;
    private final Socket socket;
    private BufferInput in;
    private PrintOutput out;
    private Command command;
    private int id;
    private volatile boolean authenticated;
    private boolean closed;

    public ClientListener(Socket socket, Context context, BaseXServer server) {
        this.context = new Context(context, this);
        this.socket = socket;
        this.server = server;
        this.last = System.currentTimeMillis();
        this.setDaemon(true);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean authenticate() {
        boolean auth;
        block5: {
            auth = false;
            try {
                String nonce = Long.toString(System.nanoTime());
                byte[] address = this.socket.getInetAddress().getAddress();
                this.out = PrintOutput.get(this.socket.getOutputStream());
                this.out.print("BaseX:" + nonce);
                this.send(true);
                this.in = new BufferInput(this.socket.getInputStream());
                String name = this.in.readString();
                String hash = this.in.readString();
                User user = this.context.users.get(name);
                boolean bl = auth = user != null && Strings.md5(String.valueOf(user.code(Algorithm.DIGEST, Code.HASH)) + nonce).equals(hash);
                if (auth) {
                    this.context.user(user);
                    this.send(true);
                    this.context.blocker.remove(address);
                    this.context.sessions.add(this);
                } else {
                    if (!name.isEmpty()) {
                        this.log(Log.LogType.ERROR, Text.ACCESS_DENIED);
                    }
                    this.context.blocker.delay(address);
                    this.send(false);
                }
            }
            catch (IOException ex) {
                if (!auth) break block5;
                Util.stack(ex);
                this.log(Log.LogType.ERROR, Util.message(ex));
                auth = false;
            }
        }
        this.server.remove(this);
        this.authenticated = auth;
        return auth;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Command c = this.command;
        if (c != null) {
            c.stop();
            do {
                Performance.sleep(1L);
            } while (this.command != null);
        }
        this.context.sessions.remove(this);
        try {
            Close.close(this.context);
            this.socket.close();
        }
        catch (Throwable ex) {
            this.log(Log.LogType.ERROR, Util.message(ex));
            Util.stack(ex);
        }
    }

    public Context context() {
        return this.context;
    }

    @Override
    public String clientName() {
        User user = this.context.user();
        return user != null ? user.name() : null;
    }

    @Override
    public String clientAddress() {
        return String.valueOf(this.socket.getInetAddress().getHostAddress()) + ':' + this.socket.getPort();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[").append(this.clientAddress()).append(']');
        if (this.context.data() != null) {
            sb.append(": ").append(this.context.data().meta.name);
        }
        return sb.toString();
    }

    private void error(String info) throws IOException {
        this.info(info, false);
    }

    private void success(String info) throws IOException {
        this.info(info, true);
    }

    private void info(String info, boolean ok) throws IOException {
        this.log(ok ? Log.LogType.OK : Log.LogType.ERROR, info);
        this.out.print(info);
        this.out.write(0);
        this.send(ok);
    }

    private void create() throws IOException {
        this.execute(new CreateDB(this.in.readString()));
    }

    private void add() throws IOException {
        this.execute(new Add(this.in.readString()));
    }

    private void replace() throws IOException {
        this.execute(new Replace(this.in.readString()));
    }

    private void store() throws IOException {
        this.execute(new Store(this.in.readString()));
    }

    private void execute(Command cmd) throws IOException {
        this.log(Log.LogType.REQUEST, cmd + " [...]");
        ServerInput si = new ServerInput(this.in);
        try {
            cmd.setInput(si);
            cmd.execute(this.context);
            this.success(cmd.info());
        }
        catch (BaseXException ex) {
            si.flush();
            this.error(ex.getMessage());
        }
    }

    private void query(ServerCmd sc) throws IOException {
        String arg = this.in.readString();
        String error = null;
        try {
            StringBuilder info = new StringBuilder();
            if (sc == ServerCmd.QUERY) {
                String query = arg;
                ServerQuery qp = new ServerQuery(query, this.context);
                qp.jc().tracer = QueryTracer.EVALINFO;
                arg = Integer.toString(this.id++);
                this.queries.put(arg, qp);
                this.out.print(arg);
                this.out.write(0);
                info.append(query);
            } else {
                ServerQuery qp = this.queries.get(arg);
                if (qp == null) {
                    if (sc != ServerCmd.CLOSE) {
                        throw new IOException("Unknown Query ID: " + arg);
                    }
                } else if (sc == ServerCmd.BIND) {
                    String key = this.in.readString();
                    String val = this.in.readString();
                    String typ = this.in.readString();
                    qp.bind(key, val, typ);
                    info.append(key).append('=').append(val);
                    if (!typ.isEmpty()) {
                        info.append(" as ").append(typ);
                    }
                } else if (sc == ServerCmd.CONTEXT) {
                    String val = this.in.readString();
                    String typ = this.in.readString();
                    qp.context(val, typ);
                    info.append(val);
                    if (!typ.isEmpty()) {
                        info.append(" as ").append(typ);
                    }
                } else if (sc == ServerCmd.RESULTS) {
                    qp.execute(this.out, true, true, false);
                } else if (sc == ServerCmd.EXEC) {
                    qp.execute(this.out, false, true, false);
                } else if (sc == ServerCmd.FULL) {
                    qp.execute(this.out, true, true, true);
                } else if (sc == ServerCmd.INFO) {
                    this.out.print(qp.info());
                } else if (sc == ServerCmd.OPTIONS) {
                    this.out.print(qp.parameters());
                } else if (sc == ServerCmd.UPDATING) {
                    this.out.print(Boolean.toString(qp.updating()));
                } else if (sc == ServerCmd.CLOSE) {
                    this.queries.remove(arg);
                } else if (sc == ServerCmd.NEXT) {
                    throw new Exception("Protocol for query iteration is out-of-date.");
                }
                this.out.write(0);
            }
            this.out.write(0);
            this.log(Log.LogType.OK, String.valueOf(sc.toString()) + '[' + arg + "] " + info);
        }
        catch (Throwable ex) {
            error = ex instanceof RuntimeException ? Util.bug(ex) : Util.message(ex);
            this.log(Log.LogType.REQUEST, (Object)((Object)sc) + "[" + arg + ']');
            this.log(Log.LogType.ERROR, error);
            this.queries.remove(arg);
        }
        if (error != null) {
            this.out.write(0);
            this.out.write(1);
            this.out.print(error);
            this.out.write(0);
        }
        this.out.flush();
    }

    private void send(boolean ok) throws IOException {
        this.out.write(ok ? 0 : 1);
        this.out.flush();
    }

    private void log(Log.LogType type, String info) {
        this.context.log.write(type, info, this.perf, this.context);
    }
}

