/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Flt;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;

public final class FltSeq
extends NativeSeq {
    private final float[] values;

    private FltSeq(float[] values) {
        super(values.length, (Type)AtomType.FLT);
        this.values = values;
    }

    @Override
    public Flt itemAt(long pos) {
        return Flt.get(this.values[(int)pos]);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || !(obj instanceof FltSeq ? !Arrays.equals(this.values, ((FltSeq)obj).values) : !super.equals(obj));
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        float[] tmp = new float[sz];
        int i = 0;
        while (i < sz) {
            tmp[sz - i - 1] = this.values[i];
            ++i;
        }
        return FltSeq.get(tmp);
    }

    public float[] toJava() {
        return this.values;
    }

    public static Value get(float[] values) {
        return values.length == 0 ? Empty.SEQ : (values.length == 1 ? Flt.get(values[0]) : new FltSeq(values));
    }

    public static Value get(Value[] values, int size) throws QueryException {
        float[] tmp = new float[size];
        int t = 0;
        Value[] valueArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Value value = valueArray[n2];
            int vs = (int)value.size();
            if (value instanceof FltSeq) {
                FltSeq seq = (FltSeq)value;
                System.arraycopy(seq.values, 0, tmp, t, vs);
                t += vs;
            } else {
                int v = 0;
                while (v < vs) {
                    tmp[t++] = value.itemAt(v).flt(null);
                    ++v;
                }
            }
            ++n2;
        }
        return FltSeq.get(tmp);
    }
}

