/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import java.util.concurrent.atomic.AtomicInteger;
import org.basex.api.dom.BXNode;
import org.basex.core.MainOptions;
import org.basex.data.MemData;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.util.DataBuilder;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public abstract class ANode
extends Item {
    private static final NodeType[] TYPES = new NodeType[]{NodeType.DOC, NodeType.ELM, NodeType.TXT, NodeType.ATT, NodeType.COM, NodeType.PI};
    private static final AtomicInteger ID = new AtomicInteger();
    public final int id = ID.incrementAndGet();
    byte[] value;
    ANode parent;

    ANode(NodeType type) {
        super(type);
    }

    @Override
    public final boolean bool(InputInfo info) {
        return true;
    }

    @Override
    public final byte[] string(InputInfo info) {
        return this.string();
    }

    public abstract byte[] string();

    @Override
    public final boolean eq(Item item, Collation coll, StaticContext sc, InputInfo info) throws QueryException {
        return item.type.isUntyped() ? (coll == null ? Token.eq(this.string(), item.string(info)) : coll.compare(this.string(), item.string(info)) == 0) : item.eq(this, coll, sc, info);
    }

    @Override
    public boolean sameKey(Item item, InputInfo info) throws QueryException {
        return item.type.isStringOrUntyped() && this.eq(item, null, null, info);
    }

    @Override
    public final int diff(Item item, Collation coll, InputInfo info) throws QueryException {
        return item.type.isUntyped() ? (coll == null ? Token.diff(this.string(), item.string(info)) : coll.compare(this.string(), item.string(info))) : -item.diff(this, coll, info);
    }

    @Override
    public final Item atomValue(QueryContext qc, InputInfo info) {
        return this.atomItem();
    }

    @Override
    public final Item atomItem(QueryContext qc, InputInfo info) {
        return this.atomItem();
    }

    private Item atomItem() {
        return this.type == NodeType.PI || this.type == NodeType.COM ? Str.get(this.string()) : new Atm(this.string());
    }

    public abstract ANode deepCopy(MainOptions var1, QueryContext var2);

    public abstract ANode finish();

    public DBNode dbNodeCopy(MainOptions opts, QueryContext qc) {
        MemData md = new MemData(opts);
        new DataBuilder(md, qc).build(this);
        return new DBNode(md);
    }

    public byte[] name() {
        return null;
    }

    public QNm qname() {
        return null;
    }

    public ANode optimize() {
        return this;
    }

    public Atts namespaces() {
        return null;
    }

    public final Atts nsScope(StaticContext sc) {
        Atts ns = new Atts();
        ANode node = this;
        do {
            Atts nsp;
            if ((nsp = node.namespaces()) == null) continue;
            int a = nsp.size() - 1;
            while (a >= 0) {
                byte[] key = nsp.name(a);
                if (!ns.contains(key)) {
                    ns.add(key, nsp.value(a));
                }
                --a;
            }
        } while ((node = node.parent()) != null && node.type == NodeType.ELM);
        if (sc != null) {
            sc.ns.inScope(ns);
        }
        return ns;
    }

    public final byte[] uri(byte[] pref) {
        Atts at = this.namespaces();
        if (at != null) {
            byte[] s = at.value(pref);
            if (s != null) {
                return s;
            }
            ANode n = this.parent();
            if (n != null) {
                return n.uri(pref);
            }
        }
        return (byte[])(pref.length == 0 ? Token.EMPTY : null);
    }

    public byte[] baseURI() {
        return Token.EMPTY;
    }

    public abstract boolean is(ANode var1);

    public abstract int diff(ANode var1);

    static int diff(ANode node1, ANode node2) {
        ANodeList nl = new ANodeList();
        ANode n = node1;
        while (n != null) {
            if (n == node2) {
                return 1;
            }
            nl.add(n);
            n = n.parent();
        }
        ANode c2 = node2;
        ANode n2 = node2;
        block1: while ((n2 = n2.parent()) != null) {
            int is = nl.size();
            int i = 1;
            while (i < is) {
                if (n2 == node1) {
                    return -1;
                }
                if (((ANode)nl.get(i)).is(n2)) {
                    ANode c1 = (ANode)nl.get(i - 1);
                    for (ANode c : n2.children()) {
                        if (c.is(c1)) {
                            return -1;
                        }
                        if (!c.is(c2)) continue;
                        return 1;
                    }
                    break block1;
                }
                ++i;
            }
            c2 = n2;
        }
        return node1.id - node2.id < 0 ? -1 : 1;
    }

    public final ANode root() {
        ANode p = this.parent();
        return p == null ? this : p.root();
    }

    public abstract ANode parent();

    protected abstract ANode parent(ANode var1);

    public abstract boolean hasChildren();

    public byte[] attribute(byte[] name) {
        return this.attribute(new QNm(name));
    }

    public byte[] attribute(QNm name) {
        ANode node;
        BasicNodeIter iter = this.attributes();
        do {
            if ((node = iter.next()) != null) continue;
            return null;
        } while (!node.qname().eq(name));
        return node.string();
    }

    public abstract BasicNodeIter ancestor();

    public abstract BasicNodeIter ancestorOrSelf();

    public abstract BasicNodeIter attributes();

    public abstract BasicNodeIter children();

    public abstract BasicNodeIter descendant();

    public abstract BasicNodeIter descendantOrSelf();

    public abstract BasicNodeIter following();

    public abstract BasicNodeIter followingSibling();

    public final BasicNodeIter parentIter() {
        return new BasicNodeIter(){
            private boolean all;

            @Override
            public ANode next() {
                if (this.all) {
                    return null;
                }
                this.all = true;
                return ANode.this.parent();
            }

            @Override
            public ANode get(long i) {
                return ANode.this.parent();
            }

            @Override
            public ANode value(QueryContext qc) {
                return ANode.this.parent();
            }

            @Override
            public long size() {
                return 1L;
            }
        };
    }

    public final BasicNodeIter preceding() {
        return new BasicNodeIter(){
            private BasicNodeIter iter;

            @Override
            public ANode next() {
                if (this.iter == null) {
                    ANodeList list = new ANodeList();
                    ANode n = ANode.this;
                    ANode p = n.parent();
                    while (p != null) {
                        if (n.type != NodeType.ATT) {
                            ANodeList tmp = new ANodeList();
                            for (ANode c : p.children()) {
                                if (c.is(n)) break;
                                tmp.add(c.finish());
                                ANode.addDesc(c.children(), tmp);
                            }
                            int t = tmp.size() - 1;
                            while (t >= 0) {
                                list.add((ANode)tmp.get(t));
                                --t;
                            }
                        }
                        n = p;
                        p = p.parent();
                    }
                    this.iter = list.iter();
                }
                return this.iter.next();
            }
        };
    }

    public final BasicNodeIter precedingSibling() {
        return new BasicNodeIter(){
            private BasicNodeIter iter;
            private int i;

            @Override
            public ANode next() {
                if (this.iter == null) {
                    if (ANode.this.type == NodeType.ATT) {
                        return null;
                    }
                    ANode r = ANode.this.parent();
                    if (r == null) {
                        return null;
                    }
                    ANodeList list = new ANodeList();
                    for (ANode n : r.children()) {
                        if (n.is(ANode.this)) break;
                        list.add(n.finish());
                    }
                    this.i = list.size();
                    this.iter = list.iter();
                }
                return this.i > 0 ? this.iter.get(--this.i) : null;
            }
        };
    }

    public final BasicNodeIter self() {
        return new BasicNodeIter(){
            private boolean all;

            @Override
            public ANode next() {
                if (this.all) {
                    return null;
                }
                this.all = true;
                return ANode.this;
            }
        };
    }

    static void addDesc(BasicNodeIter ch, ANodeList nb) {
        for (ANode n : ch) {
            nb.add(n.finish());
            ANode.addDesc(n.children(), nb);
        }
    }

    public int kind() {
        return ANode.kind(this.nodeType());
    }

    public static int kind(NodeType type) {
        switch (type) {
            case DOC: {
                return 0;
            }
            case ELM: {
                return 1;
            }
            case TXT: {
                return 2;
            }
            case ATT: {
                return 3;
            }
            case COM: {
                return 4;
            }
            case PI: {
                return 5;
            }
        }
        return -1;
    }

    public static NodeType type(int k) {
        return TYPES[k];
    }

    @Override
    public abstract BXNode toJava();

    public final NodeType nodeType() {
        return (NodeType)this.type;
    }
}

