/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util;

import java.util.ArrayList;
import org.basex.core.MainOptions;
import org.basex.data.Data;
import org.basex.index.IndexNames;
import org.basex.index.IndexType;
import org.basex.index.query.IndexToken;
import org.basex.index.query.StringToken;
import org.basex.index.stats.Stats;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.Union;
import org.basex.query.expr.index.IndexDb;
import org.basex.query.expr.index.ValueAccess;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.AxisPath;
import org.basex.query.expr.path.KindTest;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.Path;
import org.basex.query.expr.path.Step;
import org.basex.query.expr.path.Test;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.util.IndexCosts;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.TokenSet;

public final class IndexInfo {
    public final QueryContext qc;
    public final IndexDb db;
    public final Step step;
    public String optInfo;
    public NameTest test;
    public Expr expr;
    public IndexCosts costs;
    private Expr pred;
    private boolean text;

    public IndexInfo(IndexDb db, QueryContext qc, Step step) {
        this.qc = qc;
        this.db = db;
        this.step = step;
    }

    public IndexType type(Expr input, IndexType type) {
        boolean elem;
        this.pred = input;
        Step last = this.lastStep();
        if (last == null) {
            return null;
        }
        Data data = this.db.data();
        boolean bl = elem = last.test.type == NodeType.ELM;
        if (elem) {
            if (data == null || !data.meta.uptodate || !data.nspaces.isEmpty() || last.test.kind != Test.Kind.NAME) {
                return null;
            }
            this.test = (NameTest)last.test;
            Stats stats = data.elemNames.stats(data.elemNames.id(this.test.name.local()));
            if (stats == null || !stats.isLeaf()) {
                return null;
            }
        }
        boolean bl2 = this.text = elem || last.test.type == NodeType.TXT;
        IndexType it = type != null ? type : (this.text ? IndexType.TEXT : IndexType.ATTRIBUTE);
        return data == null || new IndexNames(it, data).contains(this.qname()) && this.check(it, last) ? it : null;
    }

    public boolean create(Expr search, IndexType type, InputInfo info, boolean trim) throws QueryException {
        ParseExpr root;
        if (type == null || search == null) {
            return false;
        }
        Data data = this.db.data();
        if (data == null && !this.enforce()) {
            return false;
        }
        if (search instanceof Value) {
            Item item;
            Iter iter = search.iter(this.qc);
            ArrayList<ValueAccess> tmp = new ArrayList<ValueAccess>();
            TokenSet strings = new TokenSet();
            while ((item = this.qc.next(iter)) != null) {
                if (!item.type.isStringOrUntyped()) {
                    return false;
                }
                byte[] string = item.string(info);
                if (trim) {
                    string = Token.trim(string);
                }
                int sl = string.length;
                if (type != IndexType.TOKEN && (sl == 0 || data != null && sl > data.meta.maxlen)) {
                    return false;
                }
                if (strings.contains(string)) continue;
                strings.put(string);
                IndexCosts c = this.costs(data, new StringToken(type, string));
                if (c == null) {
                    return false;
                }
                int r = c.results();
                if (r != 0) {
                    ValueAccess va = new ValueAccess(info, item, type, this.test, this.db).trim(trim);
                    tmp.add(va);
                    if (r == 1) {
                        va.exprType.assign(Occ.ZERO_ONE);
                    }
                }
                this.costs = IndexCosts.add(this.costs, c);
            }
            int vs = tmp.size();
            root = vs == 1 ? (ParseExpr)tmp.get(0) : new Union(info, tmp.toArray(new ValueAccess[vs]));
        } else {
            if (!search.seqType().type.isStringOrUntyped() || search.has(Flag.CTX, Flag.NDT)) {
                return false;
            }
            if (data != null) {
                this.costs = IndexCosts.get(Math.max(1, data.meta.size / 10));
            }
            root = new ValueAccess(info, search, type, this.test, this.db);
        }
        this.create(root, false, info, Util.info("apply % index for %", new Object[]{type, search}));
        return true;
    }

    public void create(ParseExpr root, boolean parent, InputInfo info, String opt) {
        this.expr = this.invert(this.test == null || !parent ? root : Path.get(info, root, Step.get(info, Axis.PARENT, this.test, new Expr[0])));
        this.optInfo = opt;
    }

    public IndexCosts costs(Data data, IndexToken token) {
        return this.enforce() ? IndexCosts.ENFORCE : data.costs(token);
    }

    public boolean enforce() {
        return this.qc.context.options.get(MainOptions.ENFORCEINDEX);
    }

    private boolean check(IndexType type, Step last) {
        return this.db.data().meta.index(type) && (type == IndexType.FULLTEXT ? this.text : (type == IndexType.TOKEN ? !this.text : (type == IndexType.TEXT ? this.text : !this.text && last.test.type == NodeType.ATT)));
    }

    private byte[][] qname() {
        AxisPath path;
        Step s = this.step;
        if (this.text) {
            if (this.pred instanceof AxisPath) {
                path = (AxisPath)this.pred;
                int pl = path.steps.length;
                s = path.step(pl - 1);
                if (s.axis == Axis.CHILD && s.test == KindTest.TXT) {
                    s = pl > 1 ? path.step(pl - 2) : this.step;
                }
            }
        } else if (this.pred instanceof AxisPath) {
            path = (AxisPath)this.pred;
            s = path.step(path.steps.length - 1);
        }
        if (!(s.test instanceof NameTest)) {
            return null;
        }
        NameTest nt = (NameTest)s.test;
        return new byte[][]{nt.local, nt.name == null ? null : nt.name.uri()};
    }

    private ParseExpr invert(ParseExpr root) {
        if (this.pred instanceof ContextValue) {
            if (this.text || this.step.test.name == null) {
                return root;
            }
            Step as = Step.get(this.step.info, Axis.SELF, this.step.test, new Expr[0]);
            return Path.get(root.info, root, as);
        }
        AxisPath origPath = (AxisPath)this.pred;
        Path invPath = origPath.invertPath(root, this.step);
        if (!this.text) {
            Step at = origPath.step(origPath.steps.length - 1);
            if (at.test.name != null) {
                ExprList steps = new ExprList(invPath.steps.length + 1);
                ((ExprList)((Object)steps.add(Step.get(at.info, Axis.SELF, at.test, new Expr[0])))).add(invPath.steps);
                invPath = (Path)Path.get(invPath.info, invPath.root, (Expr[])steps.finish());
            }
        }
        return invPath;
    }

    private Step lastStep() {
        if (this.pred instanceof ContextValue) {
            return this.step;
        }
        if (!(this.pred instanceof AxisPath)) {
            return null;
        }
        AxisPath path = (AxisPath)this.pred;
        if (path.root != null) {
            return null;
        }
        Step s = path.step(path.steps.length - 1);
        if (s.positional()) {
            return null;
        }
        return s;
    }
}

