/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up;

import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Array;
import org.basex.util.Atts;
import org.basex.util.Token;

public final class NamePool {
    private NameCache[] cache = new NameCache[1];
    private int size;

    public void add(QNm name, NodeType type) {
        if (type != NodeType.ATT && type != NodeType.ELM) {
            return;
        }
        int i = this.index(name, type == NodeType.ATT);
        NameCache nameCache = this.cache[i];
        nameCache.add = nameCache.add + 1;
    }

    public void remove(ANode node) {
        if (node.type != NodeType.ATT && node.type != NodeType.ELM) {
            return;
        }
        int i = this.index(node.qname(), node.type == NodeType.ATT);
        this.cache[i].del = true;
    }

    QNm duplicate() {
        int i = 0;
        while (i < this.size) {
            NameCache nc = this.cache[i];
            if (nc.attr && nc.add > (nc.del ? 2 : 1)) {
                return nc.name;
            }
            ++i;
        }
        return null;
    }

    byte[][] nsOK() {
        Atts at = new Atts();
        int i = 0;
        while (i < this.size) {
            NameCache nc = this.cache[i];
            if (nc.add > (nc.del ? 1 : 0)) {
                QNm nm = nc.name;
                byte[] pref = nm.prefix();
                byte[] uri = nm.uri();
                if (!nc.attr || uri.length != 0) {
                    byte[] u = at.value(pref);
                    if (u == null) {
                        at.add(pref, uri);
                    } else if (!Token.eq(uri, u)) {
                        return new byte[][]{uri, u};
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private int index(QNm name, boolean at) {
        int i = 0;
        while (i < this.size) {
            NameCache nc = this.cache[i];
            if (nc.name.eq(name) && nc.attr == at) {
                return i;
            }
            ++i;
        }
        if (this.size == this.cache.length) {
            this.cache = Array.copy(this.cache, new NameCache[Array.newSize(this.size)]);
        }
        NameCache nc = new NameCache();
        nc.name = name;
        nc.attr = at;
        this.cache[this.size] = nc;
        return this.size++;
    }

    private static final class NameCache {
        private QNm name;
        private boolean attr;
        private int add;
        private boolean del;

        private NameCache() {
        }
    }
}

