/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.zip;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.basex.core.BaseXException;
import org.basex.io.IOFile;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryText;
import org.basex.query.func.zip.ZipFn;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.util.DataBuilder;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Hex;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.ByteList;

public class ZipZipFile
extends ZipFn {
    private static final byte[] SRC = Token.token("src");
    private static final byte[] METHOD = Token.token("method");
    private static final String M_BASE64 = "base64";
    private static final String M_HEX = "hex";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        ANode elm = this.toElem(this.exprs[0], qc);
        if (!elm.qname().eq(Q_FILE)) {
            throw QueryError.ZIP_UNKNOWN_X.get(this.info, elm.qname());
        }
        String file = this.attribute(elm, HREF, true);
        boolean ok = true;
        try {
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try {
                    FileOutputStream fos = new FileOutputStream(file);
                    try {
                        try (ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(fos));){
                            this.create(zos, elm.children(), "", null, qc);
                        }
                        if (fos == null) return null;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (fos == null) throw throwable;
                        fos.close();
                        throw throwable;
                    }
                    fos.close();
                    return null;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                ok = false;
                throw QueryError.ZIP_FAIL_X.get(this.info, ex);
            }
        }
        finally {
            if (!ok) {
                new IOFile(file).delete();
            }
        }
    }

    final void create(ZipOutputStream zos, BasicNodeIter iter, String root, ZipFile zf, QueryContext qc) throws QueryException, IOException {
        ANode node;
        byte[] data = new byte[4096];
        while ((node = iter.next()) != null) {
            block39: {
                qc.checkStop();
                QNm mode = node.qname();
                boolean dir = mode.eq(Q_DIR);
                if (!dir && !mode.eq(Q_ENTRY)) {
                    throw QueryError.ZIP_UNKNOWN_X.get(this.info, mode);
                }
                String name = this.attribute(node, NAME, false);
                String src = this.attribute(node, SRC, false);
                if (src != null) {
                    src = src.replaceAll("\\\\", "/");
                }
                if (name == null) {
                    if (src == null) {
                        throw QueryError.ZIP_INVALID_X_X.get(this.info, node.qname(), SRC);
                    }
                    name = src;
                }
                name = name.replaceAll(".*/", "");
                if (dir) {
                    name = String.valueOf(name) + '/';
                }
                zos.putNextEntry(new ZipEntry(String.valueOf(root) + name));
                if (dir) {
                    this.create(zos, node.children(), String.valueOf(root) + name, zf, qc);
                    continue;
                }
                if (src != null) {
                    if (!new IOFile(src).exists()) {
                        throw QueryError.ZIP_NOTFOUND_X.get(this.info, src);
                    }
                    Throwable throwable = null;
                    Object var13_14 = null;
                    try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(src));){
                        int c;
                        while ((c = bis.read(data)) != -1) {
                            zos.write(data, 0, c);
                        }
                        break block39;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                BasicNodeIter ch = node.children();
                String m = this.attribute(node, METHOD, false);
                ANode n = ch.next();
                ZipEntry ze = null;
                if (zf != null && n == null) {
                    ze = zf.getEntry(String.valueOf(root) + name);
                }
                if (ze != null) {
                    int c;
                    InputStream zis = zf.getInputStream(ze);
                    while ((c = zis.read(data)) != -1) {
                        zos.write(data, 0, c);
                    }
                } else if (n != null) {
                    Object bytes;
                    boolean hex = M_HEX.equals(m);
                    if (hex || M_BASE64.equals(m)) {
                        ByteList bl = new ByteList();
                        do {
                            bl.add(n.string());
                        } while ((n = ch.next()) != null);
                        bytes = bl.finish();
                        zos.write((hex ? new Hex((byte[])bytes) : B64.get((byte[])bytes)).toJava());
                    } else {
                        ArrayOutput ao = new ArrayOutput();
                        try {
                            bytes = null;
                            Object var19_27 = null;
                            try (Serializer ser = Serializer.get(ao, ZipZipFile.sopts(node));){
                                do {
                                    ser.serialize(DataBuilder.stripNS(n, QueryText.ZIP_URI, qc.context));
                                } while ((n = ch.next()) != null);
                            }
                            catch (Throwable throwable) {
                                if (bytes == null) {
                                    bytes = throwable;
                                } else if (bytes != throwable) {
                                    ((Throwable)bytes).addSuppressed(throwable);
                                }
                                throw bytes;
                            }
                        }
                        catch (QueryIOException ex) {
                            throw ex.getCause(this.info);
                        }
                        zos.write(ao.finish());
                    }
                }
            }
            zos.closeEntry();
        }
    }

    final String attribute(ANode elm, byte[] name, boolean force) throws QueryException {
        byte[] val = elm.attribute(name);
        if (val == null && force) {
            throw QueryError.ZIP_INVALID_X_X.get(this.info, elm.qname(), name);
        }
        return val == null ? null : Token.string(val);
    }

    private static SerializerOptions sopts(ANode node) throws BaseXException {
        ANode at;
        SerializerOptions sopts = new SerializerOptions();
        BasicNodeIter ati = node.attributes();
        while ((at = ati.next()) != null) {
            byte[] name = at.qname().string();
            if (Token.eq(name, NAME, SRC)) continue;
            sopts.assign(Token.string(name), Token.string(at.string()));
        }
        return sopts;
    }
}

