/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.xquery;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.basex.core.jobs.JobException;
import org.basex.core.jobs.JobState;
import org.basex.core.users.Perm;
import org.basex.core.users.User;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.EnumOption;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

public class XQueryEval
extends StandardFunc {
    @Override
    public final Iter iter(QueryContext qc) throws QueryException {
        return this.eval(qc).iter();
    }

    @Override
    public final Value value(QueryContext qc) throws QueryException {
        return this.eval(qc).value();
    }

    protected ItemList eval(QueryContext qc) throws QueryException {
        return this.eval(qc, Token.string(this.toToken(this.exprs[0], qc)), null, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final ItemList eval(QueryContext qc, String query, String path, boolean updating) throws QueryException {
        HashMap<String, Value> bindings = this.toBindings(1, qc);
        XQueryOptions opts = this.toOptions(2, new XQueryOptions(), qc);
        QueryContext qcAnc = qc;
        int c = 5;
        while (qcAnc != null && c > 0) {
            qcAnc = qcAnc.parent;
            --c;
        }
        if (qcAnc != null) {
            throw QueryError.XQUERY_NESTED.get(this.info, new Object[0]);
        }
        User user = qc.context.user();
        Perm tmp = user.perm("");
        Timer to = null;
        Perm perm = Perm.get(opts.get(XQueryOptions.PERMISSION).toString());
        if (!user.has(perm)) {
            throw QueryError.XQUERY_PERMISSION2_X.get(this.info, new Object[]{perm});
        }
        user.perm(perm);
        try {
            Throwable throwable = null;
            Object var13_15 = null;
            try (final QueryContext qctx = new QueryContext(qc);){
                Item item;
                String bu;
                long ms;
                long mb = opts.get(XQueryOptions.MEMORY).intValue();
                if (mb != 0L) {
                    Performance.gc(2);
                    final long limit = Performance.memory() + (mb << 20);
                    to = new Timer(true);
                    to.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            if (Performance.memory() > limit) {
                                qctx.memory();
                            }
                        }
                    }, 500L, 500L);
                }
                if ((ms = (long)opts.get(XQueryOptions.TIMEOUT).intValue() * 1000L) != 0L) {
                    if (to == null) {
                        to = new Timer(true);
                    }
                    to.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            qctx.timeout();
                        }
                    }, ms);
                }
                String uri = (bu = opts.get(XQueryOptions.BASE_URI)) != null ? bu : (path != null ? path : Token.string(this.sc.baseURI().string()));
                StaticContext sctx = new StaticContext(qctx);
                sctx.baseURI(uri);
                for (Map.Entry<String, Value> it : bindings.entrySet()) {
                    String key = it.getKey();
                    Value value = it.getValue();
                    if (key.isEmpty()) {
                        qctx.context(value, sctx);
                        continue;
                    }
                    qctx.bind(key, value, sctx);
                }
                qctx.parseMain(query, null, sctx);
                if (updating) {
                    if (!(this.sc.mixUpdates || qctx.updating || qctx.root.expr.isVacuous())) {
                        throw QueryError.XQUERY_UPDATE2.get(this.info, new Object[0]);
                    }
                } else if (qctx.updating) {
                    throw QueryError.XQUERY_UPDATE1.get(this.info, new Object[0]);
                }
                ItemList items = new ItemList();
                Iter iter = qctx.iter();
                while ((item = qctx.next(iter)) != null) {
                    qc.checkStop();
                    items.add(item);
                }
                ItemList itemList = items;
                if (to != null) {
                    to.cancel();
                }
                user.perm(tmp, "");
                return itemList;
                catch (JobException ex) {
                    if (qctx.state == JobState.TIMEOUT) {
                        throw QueryError.XQUERY_TIMEOUT.get(this.info, new Object[0]);
                    }
                    if (qctx.state != JobState.MEMORY) throw ex;
                    throw QueryError.XQUERY_MEMORY.get(this.info, new Object[0]);
                }
                catch (QueryException ex) {
                    QueryError error = ex.error();
                    if (error == QueryError.BASEX_PERMISSION_X || error == QueryError.BASEX_PERMISSION_X_X) {
                        Util.debug(ex);
                        throw QueryError.XQUERY_PERMISSION1_X.get(this.info, ex.getLocalizedMessage());
                    }
                    if (opts.get(XQueryOptions.PASS) != false) throw ex;
                    ex.info(this.info);
                    throw ex;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            if (to != null) {
                to.cancel();
            }
            user.perm(tmp, "");
            throw throwable;
        }
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.lock(null) && super.accept(visitor);
    }

    public static class XQueryOptions
    extends Options {
        public static final EnumOption<Perm> PERMISSION = new EnumOption<Perm>("permission", Perm.ADMIN);
        public static final NumberOption TIMEOUT = new NumberOption("timeout", 0);
        public static final NumberOption MEMORY = new NumberOption("memory", 0);
        public static final StringOption BASE_URI = new StringOption("base-uri");
        public static final BooleanOption PASS = new BooleanOption("pass", false);
    }
}

