/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.util;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;

public final class UtilReplicate
extends StandardFunc {
    @Override
    public Value value(QueryContext qc) throws QueryException {
        Value value = this.exprs[0].value(qc);
        long mult = this.toLong(this.exprs[1], qc);
        if (mult < 0L) {
            throw QueryError.UTIL_NEGATIVE_X.get(this.info, mult);
        }
        return SingletonSeq.get(value, mult);
    }

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.value(qc).iter();
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        long m;
        Expr expr = this.exprs[0];
        Expr mult = this.exprs[1];
        SeqType st = expr.seqType();
        long l = m = mult instanceof Value ? this.toLong(mult, cc.qc) : -1L;
        if (m == 0L) {
            return Empty.SEQ;
        }
        if (m == 1L || st.zero()) {
            return expr;
        }
        this.exprType.assign(st.type, st.occ.union(m > 1L ? Occ.ONE_MORE : Occ.ZERO_MORE));
        return this;
    }
}

