/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.user;

import java.util.ArrayList;
import org.basex.core.Databases;
import org.basex.core.users.Perm;
import org.basex.core.users.User;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.value.item.Item;
import org.basex.server.ClientListener;
import org.basex.util.Token;
import org.basex.util.list.StringList;

abstract class UserFn
extends StandardFunc {
    UserFn() {
    }

    protected final StringList toPatterns(int i, QueryContext qc) throws QueryException {
        StringList patterns = new StringList();
        if (this.exprs.length > i) {
            Item item;
            Iter iter = this.exprs[i].iter(qc);
            while ((item = qc.next(iter)) != null) {
                String pattern = Token.string(this.toToken(item));
                if (!pattern.isEmpty() && !Databases.validName(pattern, true)) {
                    throw QueryError.USER_PATTERN_X.get(this.info, pattern);
                }
                patterns.add(pattern);
            }
        } else {
            patterns.add("");
        }
        return patterns;
    }

    protected final String toName(int i, QueryContext qc) throws QueryException {
        String name = this.toString(i, qc);
        if (!Databases.validName(name)) {
            throw QueryError.USER_NAME_X.get(this.info, name);
        }
        return name;
    }

    protected final User toUser(int i, QueryContext qc) throws QueryException {
        String name = this.toName(i, qc);
        User user = qc.context.users.get(name);
        if (user != qc.context.user()) {
            this.checkAdmin(qc);
        }
        if (user == null) {
            throw QueryError.USER_UNKNOWN_X.get(this.info, name);
        }
        return user;
    }

    protected final ArrayList<Perm> toPerms(int i, QueryContext qc) throws QueryException {
        ArrayList<Perm> perms = new ArrayList<Perm>();
        if (this.exprs.length > i) {
            Item item;
            Iter iter = this.exprs[i].iter(qc);
            while ((item = qc.next(iter)) != null) {
                String perm = Token.string(this.toToken(item));
                Perm p = Perm.get(perm);
                if (p == null) {
                    throw QueryError.USER_PERMISSION_X.get(this.info, perm);
                }
                perms.add(p);
            }
        } else {
            perms.add(Perm.NONE);
        }
        return perms;
    }

    protected final String toString(int i, QueryContext qc) throws QueryException {
        return Token.string(this.toToken(this.exprs[i], qc));
    }

    protected final String toSafeName(int i, QueryContext qc) throws QueryException {
        String name = this.toName(i, qc);
        this.checkSafe(qc.context.users.get(name), qc);
        return name;
    }

    protected final User toSafeUser(int i, QueryContext qc) throws QueryException {
        return this.checkSafe(this.toUser(i, qc), qc);
    }

    private User checkSafe(User user, QueryContext qc) throws QueryException {
        if (user != null) {
            String name = user.name();
            for (ClientListener s : qc.context.sessions) {
                if (!s.context().user().name().equals(name)) continue;
                throw QueryError.USER_LOGGEDIN_X.get(this.info, name);
            }
        }
        return user;
    }

    @Override
    public final boolean accept(ASTVisitor visitor) {
        return (!this.sig.has(Flag.UPD) || visitor.lock("%USER")) && super.accept(visitor);
    }
}

