/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.io.IOException;
import java.io.InputStream;
import org.basex.build.Parser;
import org.basex.build.xml.XMLParser;
import org.basex.core.MainOptions;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.in.EncodingException;
import org.basex.io.in.InputException;
import org.basex.io.in.TextInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.item.Uri;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.util.Token;

public abstract class Parse
extends StandardFunc {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Item unparsedText(QueryContext qc, boolean check, boolean encoding) throws QueryException {
        this.checkCreate(qc);
        Item item = this.exprs[0].atomItem(qc, this.info);
        if (item == null) {
            if (!check) return null;
            Bln bln = Bln.FALSE;
            return bln;
        }
        byte[] path = this.toToken(item);
        String enc = null;
        IO io = null;
        try {
            enc = encoding ? this.toEncoding(1, QueryError.ENCODING_X, qc) : null;
            String p = Token.string(path);
            if (p.indexOf(35) != -1) {
                throw QueryError.FRAGID_X.get(this.info, p);
            }
            Uri uri = Uri.uri(p);
            if (!uri.isValid()) {
                throw QueryError.INVURL_X.get(this.info, p);
            }
            if (uri.isAbsolute()) {
                io = IO.get(p);
            } else {
                if (this.sc.baseURI() == Uri.EMPTY) {
                    throw QueryError.STBASEURI.get(this.info, new Object[0]);
                }
                io = this.sc.resolve(p);
            }
            String[] rp = qc.resources.text(p);
            if (rp == null) {
                rp = qc.resources.text(io.path());
            }
            if (rp != null && rp.length > 0) {
                io = IO.get(rp[0]);
                if (rp.length > 1) {
                    enc = rp[1];
                }
            }
            Throwable throwable = null;
            Object var12_16 = null;
            try {
                Str str;
                InputStream is = io.inputStream();
                try {
                    TextInput ti = new TextInput(io).encoding(enc).validate(true);
                    if (!check) {
                        str = Str.get(ti.content());
                        return str;
                    }
                    while (ti.read() != -1) {
                    }
                    return Bln.TRUE;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (is == null) return str;
                    is.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (QueryException ex) {
            if (!check) throw ex;
            if (ex.error().is(QueryError.ErrType.XPTY)) throw ex;
            return Bln.FALSE;
        }
        catch (IOException ex) {
            if (check) {
                return Bln.FALSE;
            }
            if (!(ex instanceof InputException)) throw QueryError.RESNF_X.get(this.info, io);
            boolean inv = ex instanceof EncodingException || enc != null;
            throw (inv ? QueryError.INVCHARS_X : QueryError.WHICHCHARS_X).get(this.info, ex);
        }
    }

    ANode parseXml(QueryContext qc, boolean frag) throws QueryException {
        Item item = this.exprs[0].atomItem(qc, this.info);
        if (item == null) {
            return null;
        }
        IOContent io = new IOContent(this.toToken(item), Token.string(this.sc.baseURI().string()));
        try {
            return new DBNode(frag ? new XMLParser(io, MainOptions.get(), true) : Parser.xmlParser(io));
        }
        catch (IOException ex) {
            throw QueryError.SAXERR_X.get(this.info, ex);
        }
    }
}

