/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.IdentityHashMap;
import org.basex.data.Data;
import org.basex.index.IndexNames;
import org.basex.index.IndexType;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.index.IndexStaticDb;
import org.basex.query.expr.index.ValueAccess;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ANodeBuilder;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.TokenList;

abstract class Ids
extends StandardFunc {
    private final IdentityHashMap<Data, Boolean> indexed = new IdentityHashMap();

    Ids() {
    }

    protected BasicNodeIter ids(QueryContext qc, boolean idref) throws QueryException {
        TokenSet idSet = this.ids(this.exprs[0].atomIter(qc, this.info), qc);
        ANode root = this.checkRoot(this.toNode(this.ctxArg(1, qc), qc));
        if (this.index(root, idref)) {
            TokenList idList = new TokenList(idSet.size());
            for (byte[] id : idSet) {
                idList.add(id);
            }
            Value ids = StrSeq.get(idList);
            Data data = root.data();
            ValueAccess va = new ValueAccess(this.info, ids, idref ? IndexType.TOKEN : IndexType.ATTRIBUTE, null, new IndexStaticDb(this.info, data));
            ANodeList results = new ANodeList();
            for (ANode attr : va.iter(qc)) {
                if (!XMLToken.isId(attr.name(), idref) || data.meta.ndocs != 1 && !attr.root().is(root)) continue;
                results.add(idref ? attr : attr.parent());
            }
            return results.iter();
        }
        ANodeBuilder list = new ANodeBuilder();
        Ids.add(idSet, list, root, idref);
        return list.iter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean index(ANode root, boolean idref) {
        Data data = root.data();
        if (data == null || (idref ? !data.meta.tokenindex : !data.meta.attrindex)) {
            return false;
        }
        IdentityHashMap<Data, Boolean> identityHashMap = this.indexed;
        synchronized (identityHashMap) {
            return this.indexed.computeIfAbsent(data, d -> new IndexNames(IndexType.ATTRIBUTE, (Data)d).containsIds(idref));
        }
    }

    private static void add(TokenSet idSet, ANodeBuilder results, ANode node, boolean idref) {
        block0: for (ANode attr : node.attributes()) {
            if (!XMLToken.isId(attr.name(), idref)) continue;
            byte[][] byArray = Token.distinctTokens(attr.string());
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte[] val = byArray[n2];
                if (idSet.contains(val)) {
                    results.add(idref ? attr.finish() : node.finish());
                    continue block0;
                }
                ++n2;
            }
        }
        for (ANode child : node.children()) {
            Ids.add(idSet, results, child, idref);
        }
    }

    private ANode checkRoot(ANode node) throws QueryException {
        ANode root = node.root();
        if (root.type != NodeType.DOC) {
            throw QueryError.IDDOC.get(this.info, new Object[0]);
        }
        return root;
    }

    private TokenSet ids(Iter iter, QueryContext qc) throws QueryException {
        Item ids;
        TokenSet ts = new TokenSet();
        while ((ids = qc.next(iter)) != null) {
            byte[][] byArray = Token.distinctTokens(this.toToken(ids));
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte[] id = byArray[n2];
                ts.put(id);
                ++n2;
            }
        }
        return ts;
    }

    @Override
    public final boolean has(Flag ... flags) {
        return Flag.CTX.in(flags) && this.exprs.length == 1 || super.has(flags);
    }

    @Override
    public final boolean accept(ASTVisitor visitor) {
        return (this.exprs.length != 1 || visitor.lock("%CONTEXT")) && super.accept(visitor);
    }
}

