/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.math.BigDecimal;
import java.math.MathContext;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Range;
import org.basex.query.func.fn.FnSum;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public class FnAvg
extends FnSum {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        Expr expr = this.exprs[0];
        if (expr instanceof RangeSeq || expr instanceof Range) {
            return this.range(expr.value(qc));
        }
        if (expr instanceof SingletonSeq && (item = this.singleton((SingletonSeq)expr)) != null) {
            return item;
        }
        Iter iter = expr.atomIter(qc, this.info);
        Item item2 = iter.next();
        return item2 == null ? null : this.sum(iter, item2, true, qc);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Item item;
        Expr expr = this.exprs[0];
        if (expr instanceof RangeSeq) {
            return this.range((Value)expr);
        }
        if (expr instanceof SingletonSeq && (item = this.singleton((SingletonSeq)expr)) != null) {
            return item;
        }
        SeqType st = expr.seqType();
        if (st.zero()) {
            return expr;
        }
        if (!st.mayBeArray()) {
            Type type = st.type;
            if (type.isUntyped()) {
                type = AtomType.DBL;
            } else if (type.instanceOf(AtomType.ITR)) {
                type = AtomType.DEC;
            } else if (!type.isNumber()) {
                type = AtomType.AAT;
            }
            this.exprType.assign(type, st.oneOrMore() ? Occ.ONE : Occ.ZERO_ONE);
        }
        return this.optFirst();
    }

    private Item singleton(SingletonSeq seq) throws QueryException {
        Item item = seq.itemAt(0L);
        if (item.type.isUntyped()) {
            item = Dbl.get(item.dbl(this.info));
        }
        return item.type.isNumber() ? item : null;
    }

    private Item range(Value value) throws QueryException {
        if (value.isEmpty()) {
            return null;
        }
        long min = value.itemAt(0L).itr(this.info);
        long max = value.itemAt(value.size() - 1L).itr(this.info);
        BigDecimal sum = BigDecimal.valueOf(min).add(BigDecimal.valueOf(max));
        return Dec.get(sum.divide(BigDecimal.valueOf(2L), MathContext.DECIMAL64));
    }
}

