/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import org.basex.core.Context;
import org.basex.data.Data;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.db.DbFn;
import org.basex.query.iter.BasicIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.Value;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.Token;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public class DbList
extends DbFn {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.exprs.length == 0 ? DbList.list(qc).iter() : this.resources(qc);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.exprs.length == 0 ? DbList.list(qc) : this.resources(qc).value(qc);
    }

    private static Value list(QueryContext qc) {
        Context ctx = qc.context;
        StringList dbs = ctx.listDBs();
        TokenList list = new TokenList(dbs.size());
        for (String name : dbs) {
            list.add(name);
        }
        return StrSeq.get(list);
    }

    private Iter resources(QueryContext qc) throws QueryException {
        final Data data = this.checkData(qc);
        String path = Token.string(this.exprs.length == 1 ? Token.EMPTY : this.toToken(this.exprs[1], qc));
        final IntList docs = data.resources.docs(path);
        final TokenList bins = data.resources.binaries(path);
        final int ds = docs.size();
        int size = ds + bins.size();
        return new BasicIter<Str>((long)size){

            @Override
            public Str get(long i) {
                return i < this.size ? Str.get(this.tokenAt((int)i)) : null;
            }

            @Override
            public Value value(QueryContext q) {
                TokenList tl = new TokenList(this.size);
                int i = 0;
                while ((long)i < this.size) {
                    tl.add(this.tokenAt(i));
                    ++i;
                }
                return StrSeq.get(tl);
            }

            private byte[] tokenAt(int i) {
                return i < ds ? data.text(docs.get(i), true) : (byte[])bins.get(i - ds);
            }
        };
    }

    @Override
    public final boolean accept(ASTVisitor visitor) {
        if (this.exprs.length == 0 ? !visitor.lock(null) : !this.dataLock(visitor, 0)) {
            return false;
        }
        return super.accept(visitor);
    }
}

