/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.bin;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.bin.Bit;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.util.Token;

abstract class BinFn
extends StandardFunc {
    private static final byte[][] BIG = Token.tokens("most-significant-first", "big-endian", "BE");
    private static final byte[][] LITTLE = Token.tokens("least-significant-first", "little-endian", "LE");

    BinFn() {
    }

    final ByteBuffer unpack(QueryContext qc, long len) throws QueryException {
        B64 b64 = this.toB64(this.exprs[0], qc, false);
        Long off = this.toLong(this.exprs[1], qc);
        ByteOrder bo = this.order(2, qc);
        byte[] bytes = b64.binary(this.info);
        int bl = bytes.length;
        int[] bounds = this.bounds(off, len, bl);
        ByteBuffer bb = ByteBuffer.allocate(bounds[1]).order(bo);
        bb.put(bytes, bounds[0], bounds[1]).position(0);
        return bb;
    }

    final Int unpackInteger(QueryContext qc, boolean signed) throws QueryException {
        boolean neg;
        B64 b64 = this.toB64(this.exprs[0], qc, false);
        Long off = this.toLong(this.exprs[1], qc);
        Long size = this.toLong(this.exprs[2], qc);
        ByteOrder bo = this.order(3, qc);
        byte[] bytes = b64.binary(this.info);
        int bl = bytes.length;
        int[] bounds = this.bounds(off, size, bl);
        int o = bounds[0];
        int l = Math.min(8, bounds[1]);
        if (l == 0) {
            return Int.ZERO;
        }
        byte[] tmp = new byte[8];
        boolean bl2 = neg = signed && (bytes[0] & 0x80) != 0;
        if (bo == ByteOrder.BIG_ENDIAN) {
            int s = 8 - l;
            if (neg) {
                int i = 0;
                while (i < s) {
                    tmp[i] = -1;
                    ++i;
                }
            }
            System.arraycopy(bytes, o, tmp, s, l);
        } else {
            System.arraycopy(bytes, o, tmp, 0, l);
            if (neg) {
                int i = l;
                while (i < 8) {
                    tmp[i] = -1;
                    ++i;
                }
            }
        }
        return Int.get(ByteBuffer.wrap(tmp).order(bo).getLong());
    }

    final B64 bit(Bit op, QueryContext qc) throws QueryException {
        byte[] bytes2;
        int bl2;
        B64 b1 = this.toB64(this.exprs[0], qc, true);
        B64 b2 = this.toB64(this.exprs[1], qc, true);
        if (b1 == null || b2 == null) {
            return null;
        }
        byte[] bytes1 = b1.binary(this.info);
        int bl1 = bytes1.length;
        if (bl1 != (bl2 = (bytes2 = b2.binary(this.info)).length)) {
            throw QueryError.BIN_DLA_X_X.get(this.info, bl1, bl2);
        }
        if (bl1 == 1) {
            return B64.get(op.eval(bytes1[0], bytes2[0]));
        }
        byte[] tmp = new byte[bl1];
        int b = 0;
        while (b < bl1) {
            tmp[b] = op.eval(bytes1[b], bytes2[b]);
            ++b;
        }
        return B64.get(tmp);
    }

    final B64 pad(QueryContext qc, boolean left) throws QueryException {
        long octet;
        B64 b64 = this.toB64(this.exprs[0], qc, true);
        long size = this.toLong(this.exprs[1], qc);
        long l = octet = this.exprs.length > 2 ? this.toLong(this.exprs[2], qc) : 0L;
        if (b64 == null) {
            return null;
        }
        byte[] bytes = b64.binary(this.info);
        int bl = bytes.length;
        if (size < 0L) {
            throw QueryError.BIN_NS_X.get(this.info, size);
        }
        if (octet < 0L || octet > 255L) {
            throw QueryError.BIN_OOR_X.get(this.info, octet);
        }
        byte[] tmp = new byte[(int)((long)bl + size)];
        if (left) {
            Arrays.fill(tmp, 0, (int)size, (byte)octet);
            System.arraycopy(bytes, 0, tmp, (int)size, bl);
        } else {
            System.arraycopy(bytes, 0, tmp, 0, bl);
            Arrays.fill(tmp, bl, tmp.length, (byte)octet);
        }
        return B64.get(tmp);
    }

    final ByteOrder order(int o, QueryContext qc) throws QueryException {
        if (o >= this.exprs.length) {
            return ByteOrder.BIG_ENDIAN;
        }
        byte[] order = this.toToken(this.exprs[o], qc);
        if (Token.eq(order, BIG)) {
            return ByteOrder.BIG_ENDIAN;
        }
        if (Token.eq(order, LITTLE)) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        throw QueryError.BIN_USO_X.get(this.info, new Object[]{order});
    }

    final int[] bounds(Long off, Long len, int size) throws QueryException {
        int sz;
        int of = 0;
        if (off != null) {
            if (off < 0L || off > (long)size || off > Integer.MAX_VALUE) {
                throw QueryError.BIN_IOOR_X_X.get(this.info, off, size);
            }
            of = (int)off.longValue();
        }
        if (len != null) {
            if (len < 0L) {
                throw QueryError.BIN_NS_X.get(this.info, off);
            }
            if ((long)of + len > (long)size || len > Integer.MAX_VALUE) {
                throw QueryError.BIN_IOOR_X_X.get(this.info, (long)of + len, size);
            }
            sz = (int)len.longValue();
        } else {
            sz = size - of;
        }
        return new int[]{of, sz};
    }

    final byte[] binary2bytes(byte[] bytes) throws QueryException {
        int bl = bytes.length;
        int r = bl & 7;
        int l = 8 - r & 7;
        int s = bl + 7 >>> 3;
        byte[] tmp = new byte[s];
        int i = 0;
        while (i < bl) {
            byte b = bytes[i];
            if (b == 49) {
                int n = l + i >>> 3;
                tmp[n] = (byte)(tmp[n] | 128 >>> (i - r & 7));
            } else if (b != 48) {
                throw QueryError.BIN_NNC.get(this.info, new Object[0]);
            }
            ++i;
        }
        return tmp;
    }

    final byte[] str(int o, QueryContext qc) throws QueryException {
        Item item = this.exprs[o].atomItem(qc, this.info);
        return item == null ? null : this.toToken(item);
    }
}

