/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.archive.ArchiveCreate;
import org.basex.query.func.archive.ArchiveIn;
import org.basex.query.func.archive.ArchiveOut;
import org.basex.query.func.archive.GZIPIn;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Item;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.TokenObjMap;

public final class ArchiveUpdate
extends ArchiveCreate {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item cn;
        Item en;
        this.checkCreate(qc);
        B64 archive = this.toB64(this.exprs[0], qc, false);
        TokenObjMap<Item[]> hm = new TokenObjMap<Item[]>();
        Iter entries = this.exprs[1].iter(qc);
        Iter contents = this.exprs[2].iter(qc);
        int e = 0;
        int c = 0;
        while (true) {
            en = qc.next(entries);
            cn = contents.next();
            if (en == null || cn == null) break;
            hm.put(this.checkElemToken(en).string(this.info), new Item[]{en, cn});
            ++e;
            ++c;
        }
        if (cn != null) {
            do {
                ++c;
            } while (contents.next() != null);
        }
        if (en != null) {
            do {
                ++e;
            } while (entries.next() != null);
        }
        if (e != c) {
            throw QueryError.ARCHIVE_NUMBER_X_X.get(this.info, e, c);
        }
        try {
            Throwable throwable = null;
            Object var12_14 = null;
            try {
                B64 b64;
                ArchiveIn in = ArchiveIn.get(archive.input(this.info), this.info);
                try {
                    block26: {
                        ArchiveOut out = ArchiveOut.get(in.format(), this.info);
                        try {
                            if (in instanceof GZIPIn) {
                                throw QueryError.ARCHIVE_MODIFY_X.get(this.info, in.format().toUpperCase(Locale.ENGLISH));
                            }
                            while (true) {
                                if (!in.more()) break;
                                if (hm.contains(Token.token(in.entry().getName()))) continue;
                                out.write(in);
                            }
                            Iterator<byte[]> iterator = hm.iterator();
                            while (true) {
                                if (!iterator.hasNext()) {
                                    b64 = B64.get(out.finish());
                                    return b64;
                                }
                                byte[] h = iterator.next();
                                if (h == null) continue;
                                Item[] it = (Item[])hm.get(h);
                                this.add(it[0], it[1], out, 8, qc);
                            }
                        }
                        finally {
                            if (out == null) break block26;
                            out.close();
                        }
                    }
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                {
                    return b64;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw QueryError.ARCHIVE_ERROR_X.get(this.info, ex);
        }
    }
}

